/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.cql.Statement;
import io.micrometer.observation.Observation;
import javax.annotation.Nonnull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.cassandra.observability.CassandraObservationSupplier;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

final class ObservationStatement
implements MethodInterceptor {
    private final Observation observation;
    private Statement<?> delegate;

    private ObservationStatement(Observation observation, Statement<?> delegate) {
        this.observation = observation;
        this.delegate = delegate;
    }

    public static <T> T createProxy(Observation observation, T target) {
        ProxyFactory factory = new ProxyFactory(ClassUtils.getAllInterfaces(target));
        factory.addInterface(CassandraObservationSupplier.class);
        factory.setTarget(target);
        factory.addAdvice((Advice)new ObservationStatement(observation, (Statement)target));
        return (T)factory.getProxy();
    }

    public static boolean isObservationStatement(Statement<?> statement) {
        return statement instanceof CassandraObservationSupplier;
    }

    @Nullable
    public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getName().equals("getObservation")) {
            return this.observation;
        }
        Object result = invocation.proceed();
        if (result instanceof Statement) {
            this.delegate = (Statement)result;
        }
        return result;
    }
}

