/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.Row;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.CassandraJsr310Converters;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private Class<T> mappedClass;
    private boolean checkFullyPopulated = false;
    private boolean primitivesDefaultedForNullValue = false;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    private Map<String, PropertyDescriptor> mappedFields;
    @Nullable
    private Set<String> mappedProperties;

    public BeanPropertyRowMapper() {
        DefaultConversionService conversionService = new DefaultConversionService();
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((DefaultConversionService)conversionService).addConverter(arg_0));
        CassandraJsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((DefaultConversionService)conversionService).addConverter(arg_0));
        this.conversionService = conversionService;
    }

    public BeanPropertyRowMapper(Class<T> mappedClass) {
        DefaultConversionService conversionService = new DefaultConversionService();
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((DefaultConversionService)conversionService).addConverter(arg_0));
        CassandraJsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((DefaultConversionService)conversionService).addConverter(arg_0));
        this.conversionService = conversionService;
        this.setMappedClass(mappedClass);
    }

    public BeanPropertyRowMapper(Class<T> mappedClass, boolean checkFullyPopulated) {
        DefaultConversionService conversionService = new DefaultConversionService();
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((DefaultConversionService)conversionService).addConverter(arg_0));
        CassandraJsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((DefaultConversionService)conversionService).addConverter(arg_0));
        this.conversionService = conversionService;
        this.initialize(mappedClass);
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public void setMappedClass(Class<T> mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (this.mappedClass != mappedClass) {
            throw new InvalidDataAccessApiUsageException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    @Nullable
    public final Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public void setCheckFullyPopulated(boolean checkFullyPopulated) {
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public boolean isCheckFullyPopulated() {
        return this.checkFullyPopulated;
    }

    public void setPrimitivesDefaultedForNullValue(boolean primitivesDefaultedForNullValue) {
        this.primitivesDefaultedForNullValue = primitivesDefaultedForNullValue;
    }

    public boolean isPrimitivesDefaultedForNullValue() {
        return this.primitivesDefaultedForNullValue;
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    protected void initialize(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        this.mappedProperties = new HashSet<String>();
        for (PropertyDescriptor pd : BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(this.lowerCaseName(pd.getName()), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (!this.lowerCaseName(pd.getName()).equals(underscoredName)) {
                this.mappedFields.put(underscoredName, pd);
            }
            this.mappedProperties.add(pd.getName());
        }
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('_').append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    protected String lowerCaseName(String name) {
        return name.toLowerCase(Locale.US);
    }

    @Override
    public T mapRow(Row row, int rowNumber) {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper((BeanWrapper)bw);
        T mappedObject = this.constructMappedInstance(row, (TypeConverter)bw);
        bw.setBeanInstance(mappedObject);
        int columnCount = row.getColumnDefinitions().size();
        HashSet<String> populatedProperties = this.isCheckFullyPopulated() ? new HashSet<String>() : null;
        for (int index = 0; index < columnCount; ++index) {
            PropertyDescriptor pd;
            String column = row.getColumnDefinitions().get(index).getName().toString();
            String field = this.lowerCaseName(StringUtils.delete((String)column, (String)" "));
            PropertyDescriptor propertyDescriptor = pd = this.mappedFields != null ? this.mappedFields.get(field) : null;
            if (pd != null) {
                try {
                    Object value = this.getColumnValue(row, index, pd);
                    if (rowNumber == 0 && this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Mapping column '" + column + "' to property '" + pd.getName() + "' of type '" + ClassUtils.getQualifiedName(pd.getPropertyType()) + "'"));
                    }
                    try {
                        bw.setPropertyValue(pd.getName(), value);
                    }
                    catch (TypeMismatchException ex) {
                        if (value == null && this.primitivesDefaultedForNullValue) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Intercepted TypeMismatchException for row " + rowNumber + " and column '" + column + "' with null value when setting property '" + pd.getName() + "' of type '" + ClassUtils.getQualifiedName(pd.getPropertyType()) + "' on object: " + mappedObject), (Throwable)ex);
                            }
                        }
                        throw ex;
                    }
                    if (populatedProperties == null) continue;
                    populatedProperties.add(pd.getName());
                    continue;
                }
                catch (NotWritablePropertyException ex) {
                    throw new DataRetrievalFailureException("Unable to map column '" + column + "' to property '" + pd.getName() + "'", (Throwable)ex);
                }
            }
            if (rowNumber != 0 || !this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("No property found for column '" + column + "' mapped to field '" + field + "'"));
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedProperties)) {
            throw new InvalidDataAccessApiUsageException("Given Row does not contain all columns necessary to populate object of " + this.mappedClass + ": " + this.mappedProperties);
        }
        return mappedObject;
    }

    protected T constructMappedInstance(Row row, TypeConverter tc) {
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        return (T)BeanUtils.instantiateClass(this.mappedClass);
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        ConversionService cs = this.getConversionService();
        if (cs != null) {
            bw.setConversionService(cs);
        }
    }

    @Nullable
    protected Object getColumnValue(Row row, int index, PropertyDescriptor pd) {
        return row.get(index, pd.getPropertyType());
    }

    @Nullable
    protected Object getColumnValue(Row row, int index, Class<?> paramType) {
        return row.getObject(index);
    }

    public static <T> BeanPropertyRowMapper<T> newInstance(Class<T> mappedClass) {
        return new BeanPropertyRowMapper<T>(mappedClass);
    }

    public static <T> BeanPropertyRowMapper<T> newInstance(Class<T> mappedClass, @Nullable ConversionService conversionService) {
        BeanPropertyRowMapper<T> rowMapper = BeanPropertyRowMapper.newInstance(mappedClass);
        rowMapper.setConversionService(conversionService);
        return rowMapper;
    }
}

