/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.QueryResultConverter;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.domain.Slice;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public interface ExecutableSelectOperation {
    public <T> ExecutableSelect<T> query(Class<T> var1);

    public UntypedSelect query(String var1);

    public UntypedSelect query(Statement<?> var1);

    public static interface ExecutableSelect<T>
    extends SelectWithTable<T>,
    SelectWithProjection<T> {
    }

    public static interface TerminatingResults<T> {
        @Contract(value="_ -> new")
        public <R> TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> var1);

        default public Optional<T> first() {
            return Optional.ofNullable(this.firstValue());
        }

        public @Nullable T firstValue();

        default public Optional<T> one() {
            return Optional.ofNullable(this.oneValue());
        }

        public @Nullable T oneValue();

        public List<T> all();

        public Slice<T> slice();

        default public Stream<T> stream() {
            return this.all().stream();
        }
    }

    public static interface TerminatingProjections {
        public long count();

        default public boolean exists() {
            return this.count() > 0L;
        }
    }

    public static interface TerminatingSelect<T>
    extends TerminatingProjections,
    TerminatingResults<T> {
    }

    public static interface SelectWithQuery<T>
    extends TerminatingSelect<T> {
        @Contract(value="_ -> new")
        public TerminatingSelect<T> matching(Query var1);
    }

    public static interface SelectWithProjection<T>
    extends SelectWithQuery<T> {
        @Contract(value="_ -> new")
        public <R> SelectWithQuery<R> as(Class<R> var1);
    }

    public static interface SelectWithTable<T>
    extends SelectWithQuery<T> {
        @Contract(value="_ -> new")
        default public SelectWithProjection<T> inTable(String table) {
            Assert.hasText((String)table, (String)"Table name must not be null or empty");
            return this.inTable(CqlIdentifier.fromCql((String)table));
        }

        @Contract(value="_ -> new")
        public SelectWithProjection<T> inTable(CqlIdentifier var1);
    }

    public static interface UntypedSelect
    extends TerminatingProjections {
        @Contract(value="_ -> new")
        public <T> TerminatingResults<T> as(Class<T> var1);

        @Contract(value="_ -> new")
        default public <T> TerminatingResults<T> map(Function<Row, ? extends T> mapper) {
            return this.map((Row row, int rowNum) -> mapper.apply(row));
        }

        @Contract(value="_ -> new")
        public <T> TerminatingResults<T> map(RowMapper<T> var1);
    }
}

