/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class EntityMapping {
    private Map<String, PropertyMapping> propertyMappings = Collections.emptyMap();
    private @Nullable String entityClassName;
    private String tableName = "";

    public EntityMapping(String entityClassName, String tableName) {
        this.setEntityClassName(entityClassName);
        this.setTableName(tableName);
    }

    public @Nullable String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        Assert.hasText((String)entityClassName, (String)"Entity class name must not be null or empty");
        this.entityClassName = entityClassName;
    }

    public Map<String, PropertyMapping> getPropertyMappings() {
        return Collections.unmodifiableMap(this.propertyMappings);
    }

    public void setPropertyMappings(@Nullable Map<String, PropertyMapping> propertyMappings) {
        this.propertyMappings = propertyMappings != null ? new HashMap<String, PropertyMapping>(propertyMappings) : Collections.emptyMap();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Assert.notNull((Object)tableName, (String)"Table name must not be null or empty");
        this.tableName = tableName;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityMapping)) {
            return false;
        }
        EntityMapping that = (EntityMapping)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getEntityClassName(), (Object)that.getEntityClassName()) && ObjectUtils.nullSafeEquals((Object)this.getTableName(), (Object)that.getTableName());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getEntityClassName());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getTableName());
        return hashValue;
    }

    public String toString() {
        return String.format("{ @type = %1$s, entityClassName = %2$s, tableName = %3$s, propertyMappings = %4$s }", this.getClass().getName(), this.getEntityClassName(), this.getTableName(), this.toString(this.getPropertyMappings()));
    }

    private String toString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("[");
        int count = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.append(++count > 1 ? ", " : "");
            builder.append(String.format("%1$s = %2$s", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }
}

