/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PropertyPath
implements Iterable<PropertyPath> {
    private static final String DELIMITERS = "_\\.";
    private static final String ALL_UPPERCASE = "[A-Z0-9._$]+";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private final TypeInformation<?> owningType;
    private final String name;
    private final TypeInformation<?> type;
    private final boolean isCollection;
    private PropertyPath next;

    PropertyPath(String name, Class<?> owningType) {
        this(name, ClassTypeInformation.from(owningType), null);
    }

    PropertyPath(String name, TypeInformation<?> owningType, List<PropertyPath> base) {
        Assert.hasText((String)name);
        Assert.notNull(owningType);
        String propertyName = name.matches(ALL_UPPERCASE) ? name : StringUtils.uncapitalize((String)name);
        TypeInformation<?> propertyType = owningType.getProperty(propertyName);
        if (propertyType == null) {
            throw new PropertyReferenceException(propertyName, owningType, base);
        }
        this.owningType = owningType;
        this.isCollection = propertyType.isCollectionLike();
        this.type = propertyType.getActualType();
        this.name = propertyName;
    }

    public TypeInformation<?> getOwningType() {
        return this.owningType;
    }

    public String getSegment() {
        return this.name;
    }

    public PropertyPath getLeafProperty() {
        PropertyPath result = this;
        while (result.hasNext()) {
            result = result.next();
        }
        return result;
    }

    public Class<?> getType() {
        return this.type.getType();
    }

    public PropertyPath next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getSegment() + "." + this.next().toDotPath();
        }
        return this.getSegment();
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PropertyPath that = (PropertyPath)obj;
        return this.name.equals(that.name) && this.type.equals(that.type) && ObjectUtils.nullSafeEquals((Object)this.next, (Object)that.next);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.name.hashCode();
        result += 31 * this.type.hashCode();
        return result += 31 * (this.next == null ? 0 : this.next.hashCode());
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            private PropertyPath current;
            {
                this.current = PropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public PropertyPath next() {
                PropertyPath result = this.current;
                this.current = this.current.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PropertyPath from(String source, Class<?> type) {
        return PropertyPath.from(source, ClassTypeInformation.from(type));
    }

    public static PropertyPath from(String source, TypeInformation<?> type) {
        Assert.hasText((String)source, (String)"Source must not be null or empty!");
        Assert.notNull(type, (String)"TypeInformation must not be null or empty!");
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher = SPLITTER.matcher("_" + source);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        PropertyPath result = null;
        Stack<PropertyPath> current = new Stack<PropertyPath>();
        while (parts.hasNext()) {
            if (result == null) {
                result = PropertyPath.create((String)parts.next(), type, current);
                current.push(result);
                continue;
            }
            current.push(PropertyPath.create((String)parts.next(), current));
        }
        return result;
    }

    private static PropertyPath create(String source, Stack<PropertyPath> base) {
        PropertyPath propertyPath;
        PropertyPath previous = base.peek();
        previous.next = propertyPath = PropertyPath.create(source, previous.type, base);
        return propertyPath;
    }

    private static PropertyPath create(String source, TypeInformation<?> type, List<PropertyPath> base) {
        return PropertyPath.create(source, type, "", base);
    }

    private static PropertyPath create(String source, TypeInformation<?> type, String addTail, List<PropertyPath> base) {
        PropertyReferenceException exception = null;
        PropertyPath current = null;
        try {
            current = new PropertyPath(source, type, base);
            if (!base.isEmpty()) {
                base.get((int)(base.size() - 1)).next = current;
            }
            ArrayList<PropertyPath> newBase = new ArrayList<PropertyPath>(base);
            newBase.add(current);
            if (StringUtils.hasText((String)addTail)) {
                current.next = PropertyPath.create(addTail, current.type, newBase);
            }
            return current;
        }
        catch (PropertyReferenceException e) {
            if (current != null) {
                throw e;
            }
            exception = e;
            Pattern pattern = Pattern.compile("\\p{Lu}+\\p{Ll}*$");
            Matcher matcher = pattern.matcher(source);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source.substring(0, position);
                String tail = source.substring(position);
                try {
                    return PropertyPath.create(head, type, tail + addTail, base);
                }
                catch (PropertyReferenceException e2) {
                    throw e2.hasDeeperResolutionDepthThan(exception) ? e2 : exception;
                }
            }
            throw exception;
        }
    }

    public String toString() {
        return String.format("%s.%s", this.owningType.getType().getSimpleName(), this.toDotPath());
    }
}

