/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultCrudMethods
implements CrudMethods {
    private static final String FIND_ONE = "findOne";
    private static final String SAVE = "save";
    private static final String FIND_ALL = "findAll";
    private static final String DELETE = "delete";
    private final Method findAllMethod;
    private final Method findOneMethod;
    private final Method saveMethod;
    private final Method deleteMethod;

    public DefaultCrudMethods(RepositoryMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"RepositoryInformation must not be null!");
        this.findOneMethod = this.selectMostSuitableFindOneMethod(metadata);
        this.findAllMethod = this.selectMostSuitableFindAllMethod(metadata);
        this.deleteMethod = this.selectMostSuitableDeleteMethod(metadata);
        this.saveMethod = this.selectMostSuitableSaveMethod(metadata);
    }

    private Method selectMostSuitableSaveMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getDomainType(), Object.class)) {
            Method saveMethodCandidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), (String)SAVE, (Class[])new Class[]{type});
            if (saveMethodCandidate == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(saveMethodCandidate, metadata.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableDeleteMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getDomainType(), metadata.getIdType(), Serializable.class, Iterable.class)) {
            Method candidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), (String)DELETE, (Class[])new Class[]{type});
            if (candidate == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableFindAllMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(Pageable.class, Sort.class)) {
            Method candidate;
            if (!ClassUtils.hasMethod(metadata.getRepositoryInterface(), (String)FIND_ALL, (Class[])new Class[]{type}) || (candidate = ReflectionUtils.findMethod(PagingAndSortingRepository.class, (String)FIND_ALL, (Class[])new Class[]{type})) == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        if (ClassUtils.hasMethod(metadata.getRepositoryInterface(), (String)FIND_ALL, (Class[])new Class[0])) {
            return DefaultCrudMethods.getMostSpecificMethod(ReflectionUtils.findMethod(CrudRepository.class, (String)FIND_ALL), metadata.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableFindOneMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getIdType(), Serializable.class)) {
            Method candidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), (String)FIND_ONE, (Class[])new Class[]{type});
            if (candidate == null) continue;
            return DefaultCrudMethods.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        return null;
    }

    private static Method getMostSpecificMethod(Method method, Class<?> type) {
        Method result = ClassUtils.getMostSpecificMethod((Method)method, type);
        if (result == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Method)result);
        return result;
    }

    @Override
    public Method getSaveMethod() {
        return this.saveMethod;
    }

    @Override
    public boolean hasSaveMethod() {
        return this.saveMethod != null;
    }

    @Override
    public Method getFindAllMethod() {
        return this.findAllMethod;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.findAllMethod != null;
    }

    @Override
    public Method getFindOneMethod() {
        return this.findOneMethod;
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.findOneMethod != null;
    }

    @Override
    public boolean hasDelete() {
        return this.deleteMethod != null;
    }

    @Override
    public Method getDeleteMethod() {
        return this.deleteMethod;
    }
}

