/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.type.classreading;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import org.springframework.core.type.classreading.MethodMetadataReadingVisitor;
import org.springframework.data.type.MethodsMetadata;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.util.Assert;

class DefaultMethodsMetadataReader
implements MethodsMetadataReader {
    private final Resource resource;
    private final ClassMetadata classMetadata;
    private final AnnotationMetadata annotationMetadata;
    private final MethodsMetadata methodsMetadata;

    DefaultMethodsMetadataReader(Resource resource, ClassLoader classLoader) throws IOException {
        this.resource = resource;
        ClassReader classReader = null;
        InputStream is = null;
        try {
            is = new BufferedInputStream(this.getResource().getInputStream());
            classReader = new ClassReader(is);
        }
        catch (IllegalArgumentException ex) {
            throw new NestedIOException("ASM ClassReader failed to parse class file - probably due to a new Java class file version that isn't supported yet: " + this.getResource(), (Throwable)ex);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        MethodsMetadataReadingVisitor visitor = new MethodsMetadataReadingVisitor(classLoader);
        classReader.accept((ClassVisitor)visitor, 2);
        this.classMetadata = visitor;
        this.annotationMetadata = visitor;
        this.methodsMetadata = visitor;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public MethodsMetadata getMethodsMetadata() {
        return this.methodsMetadata;
    }

    static class MethodsMetadataReadingVisitor
    extends AnnotationMetadataReadingVisitor
    implements MethodsMetadata {
        MethodsMetadataReadingVisitor(ClassLoader classLoader) {
            super(classLoader);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 0x40) != 0) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            if (name.equals("<init>")) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            MethodMetadataReadingVisitor visitor = new MethodMetadataReadingVisitor(name, access, this.getClassName(), Type.getReturnType((String)desc).getClassName(), this.classLoader, this.methodMetadataSet);
            this.methodMetadataSet.add(visitor);
            return visitor;
        }

        @Override
        public Set<MethodMetadata> getMethods() {
            return Collections.unmodifiableSet(this.methodMetadataSet);
        }

        @Override
        public Set<MethodMetadata> getMethods(String name) {
            Assert.hasText((String)name, (String)"Method name must not be null or empty");
            LinkedHashSet<MethodMetadata> result = new LinkedHashSet<MethodMetadata>(4);
            for (MethodMetadata metadata : this.methodMetadataSet) {
                if (!metadata.getMethodName().equals(name)) continue;
                result.add(metadata);
            }
            return Collections.unmodifiableSet(result);
        }
    }
}

