/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.crossstore;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.crossstore.ChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapChangeSet
implements ChangeSet {
    private final Map<String, Object> values;

    public HashMapChangeSet(Map<String, Object> values) {
        this.values = values;
    }

    public HashMapChangeSet() {
        this(new HashMap<String, Object>());
    }

    @Override
    public void set(String key, Object o) {
        this.values.put(key, o);
    }

    public String toString() {
        return "HashMapChangeSet: values=[" + this.values + "]";
    }

    @Override
    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public Object removeProperty(String k) {
        return this.values.remove(k);
    }

    @Override
    public <T> T get(String key, Class<T> requiredClass, ConversionService conversionService) {
        return (T)conversionService.convert(this.values.get(key), requiredClass);
    }
}

