/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactorySupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingContextIsNewStrategyFactory
extends IsNewStrategyFactorySupport {
    private final MappingContext<? extends PersistentEntity<?, ?>, ?> context;

    public MappingContextIsNewStrategyFactory(MappingContext<? extends PersistentEntity<?, ?>, ?> context) {
        Assert.notNull(context, (String)"MappingContext must not be null!");
        this.context = context;
    }

    @Override
    protected IsNewStrategy doGetIsNewStrategy(Class<?> type) {
        PersistentEntity<?, ?> entity = this.context.getPersistentEntity(type);
        if (entity == null) {
            return null;
        }
        if (entity.hasVersionProperty()) {
            return new PropertyIsNullOrZeroNumberIsNewStrategy((PersistentProperty<?>)entity.getVersionProperty());
        }
        if (entity.hasIdProperty()) {
            return new PropertyIsNullIsNewStrategy((PersistentProperty<?>)entity.getIdProperty());
        }
        throw new MappingException(String.format("Cannot determine IsNewStrategy for type %s!", type));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyIsNullOrZeroNumberIsNewStrategy
    extends PersistentPropertyInspectingIsNewStrategy {
        public PropertyIsNullOrZeroNumberIsNewStrategy(PersistentProperty<?> property) {
            super(property);
        }

        @Override
        protected boolean decideIsNew(Object property) {
            if (property == null) {
                return true;
            }
            if (!(property instanceof Number)) {
                return false;
            }
            return ((Number)property).longValue() == 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyIsNullIsNewStrategy
    extends PersistentPropertyInspectingIsNewStrategy {
        public PropertyIsNullIsNewStrategy(PersistentProperty<?> property) {
            super(property);
        }

        @Override
        protected boolean decideIsNew(Object property) {
            return property == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class PersistentPropertyInspectingIsNewStrategy
    implements IsNewStrategy {
        private final PersistentProperty<?> property;

        public PersistentPropertyInspectingIsNewStrategy(PersistentProperty<?> property) {
            Assert.notNull(property, (String)"PersistentProperty must not be null!");
            this.property = property;
        }

        @Override
        public boolean isNew(Object entity) {
            BeanWrapper wrapper = BeanWrapper.create(entity, null);
            Object propertyValue = wrapper.getProperty(this.property);
            return this.decideIsNew(propertyValue);
        }

        protected abstract boolean decideIsNew(Object var1);
    }
}

