/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AbstractPersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationBasedPersistentProperty<P extends PersistentProperty<P>>
extends AbstractPersistentProperty<P> {
    private final Value value;
    private final Map<Class<? extends Annotation>, Annotation> annotationCache = new HashMap<Class<? extends Annotation>, Annotation>();

    public AnnotationBasedPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        this.populateAnnotationCache(field);
        this.value = this.findAnnotation(Value.class);
    }

    private final void populateAnnotationCache(Field field) {
        for (Method method : Arrays.asList(this.getGetter(), this.getSetter())) {
            if (method == null) continue;
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (this.annotationCache.containsKey(annotationType)) {
                    throw new MappingException(String.format("Ambiguous mapping! Annotation %s configured multiple times on accessor methods of property %s in class %s!", annotationType, this.getName(), this.getOwner().getType().getName()));
                }
                this.annotationCache.put(annotationType, annotation);
            }
        }
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (this.annotationCache.containsKey(annotationType)) continue;
            this.annotationCache.put(annotationType, annotation);
        }
    }

    @Override
    public String getSpelExpression() {
        return this.value == null ? null : this.value.value();
    }

    @Override
    public boolean isTransient() {
        boolean isTransient = super.isTransient() || this.isAnnotationPresent(Transient.class);
        return isTransient || this.isAnnotationPresent(Value.class) || this.isAnnotationPresent(Autowired.class);
    }

    @Override
    public boolean isIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    @Override
    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    @Override
    public boolean isAssociation() {
        return !this.isTransient() && this.isAnnotationPresent(Reference.class);
    }

    public <A extends Annotation> A findAnnotation(Class<? extends A> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null!");
        if (this.annotationCache != null && this.annotationCache.containsKey(annotationType)) {
            return (A)this.annotationCache.get(annotationType);
        }
        for (Method method : Arrays.asList(this.getGetter(), this.getSetter())) {
            Annotation annotation;
            if (method == null || (annotation = AnnotationUtils.findAnnotation((Method)method, annotationType)) == null) continue;
            return (A)this.cacheAndReturn(annotationType, annotation);
        }
        return (A)this.cacheAndReturn(annotationType, AnnotationUtils.getAnnotation((AnnotatedElement)this.field, annotationType));
    }

    private <A extends Annotation> A cacheAndReturn(Class<? extends A> type, A annotation) {
        if (this.annotationCache != null) {
            this.annotationCache.put(type, annotation);
        }
        return annotation;
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.findAnnotation(annotationType) != null;
    }

    @Override
    public String toString() {
        if (this.annotationCache.isEmpty()) {
            this.populateAnnotationCache(this.field);
        }
        StringBuilder builder = new StringBuilder();
        for (Annotation annotation : this.annotationCache.values()) {
            if (annotation == null) continue;
            builder.append(((Object)annotation).toString()).append(" ");
        }
        return builder.toString() + super.toString();
    }
}

