/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CdiRepositoryExtensionSupport
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdiRepositoryExtensionSupport.class);
    private final Map<Class<?>, Set<Annotation>> repositoryTypes = new HashMap();

    protected <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class repositoryType = annotatedType.getJavaClass();
        if (this.isRepository(repositoryType)) {
            Set<Annotation> qualifiers = this.getQualifiers(repositoryType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Discovered repository type '%s' with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.repositoryTypes.put(repositoryType, qualifiers);
        }
    }

    private boolean isRepository(Class<?> type) {
        boolean isInterface = type.isInterface();
        boolean extendsRepository = Repository.class.isAssignableFrom(type);
        boolean isAnnotated = type.isAnnotationPresent(RepositoryDefinition.class);
        boolean excludedByAnnotation = type.isAnnotationPresent(NoRepositoryBean.class);
        return isInterface && (extendsRepository || isAnnotated) && !excludedByAnnotation;
    }

    private Set<Annotation> getQualifiers(Class<?> type) {
        Annotation[] annotations;
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotations = type.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Qualifier.class)) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.isEmpty()) {
            qualifiers.add((Annotation)((Object)DefaultAnnotationLiteral.INSTANCE));
        }
        qualifiers.add((Annotation)((Object)AnyAnnotationLiteral.INSTANCE));
        return qualifiers;
    }

    protected Iterable<Map.Entry<Class<?>, Set<Annotation>>> getRepositoryTypes() {
        return this.repositoryTypes.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnyAnnotationLiteral
    extends AnnotationLiteral<Any>
    implements Any {
        private static final long serialVersionUID = 7261821376671361463L;
        private static final AnyAnnotationLiteral INSTANCE = new AnyAnnotationLiteral();

        private AnyAnnotationLiteral() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultAnnotationLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 511359421048623933L;
        private static final DefaultAnnotationLiteral INSTANCE = new DefaultAnnotationLiteral();

        private DefaultAnnotationLiteral() {
        }
    }
}

