/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.data.repository.init.JacksonRepositoryPopulatorFactoryBean;
import org.springframework.data.repository.init.UnmarshallerRepositoryPopulatorFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ResourceReaderRepositoryPopulatorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        String name = element.getLocalName();
        return "unmarshaller-populator".equals(name) ? UnmarshallerRepositoryPopulatorFactoryBean.class.getName() : JacksonRepositoryPopulatorFactoryBean.class.getName();
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String localName = element.getLocalName();
        builder.addPropertyValue("resources", (Object)element.getAttribute("locations"));
        if ("unmarshaller-populator".equals(localName)) {
            this.parseXmlPopulator(element, builder);
        } else if ("jackson-populator".equals(localName)) {
            this.parseJsonPopulator(element, builder);
        }
    }

    private void parseJsonPopulator(Element element, BeanDefinitionBuilder builder) {
        String objectMapperRef = element.getAttribute("object-mapper-ref");
        if (StringUtils.hasText((String)objectMapperRef)) {
            builder.addPropertyReference("mapper", objectMapperRef);
        }
    }

    private void parseXmlPopulator(Element element, BeanDefinitionBuilder builder) {
        String unmarshallerRefName = element.getAttribute("unmarshaller-ref");
        if (StringUtils.hasText((String)unmarshallerRefName)) {
            builder.addPropertyReference("unmarshaller", unmarshallerRefName);
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

