/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultCrudMethods;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public abstract class AbstractRepositoryMetadata
implements RepositoryMetadata {
    private final TypeInformation<?> typeInformation;
    private final Class<?> repositoryInterface;
    private CrudMethods crudMethods;

    public AbstractRepositoryMetadata(Class<?> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Given type must not be null!");
        Assert.isTrue((boolean)repositoryInterface.isInterface(), (String)"Given type must be an interface!");
        this.repositoryInterface = repositoryInterface;
        this.typeInformation = ClassTypeInformation.from(repositoryInterface);
    }

    @Override
    public Class<?> getReturnedDomainClass(Method method) {
        TypeInformation<?> returnTypeInfo = this.typeInformation.getReturnType(method);
        Class<?> rawType = returnTypeInfo.getType();
        boolean needToUnwrap = Iterable.class.isAssignableFrom(rawType) || rawType.isArray();
        return needToUnwrap ? returnTypeInfo.getComponentType().getType() : rawType;
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }

    @Override
    public CrudMethods getCrudMethods() {
        if (this.crudMethods == null) {
            this.crudMethods = new DefaultCrudMethods(this);
        }
        return this.crudMethods;
    }

    @Override
    public boolean isPagingRepository() {
        Method findAllMethod = this.getCrudMethods().getFindAllMethod();
        if (findAllMethod == null) {
            return false;
        }
        return Arrays.asList(findAllMethod.getParameterTypes()).contains(Pageable.class);
    }
}

