/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.OrderBySource;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PartTree
implements Iterable<OrPart> {
    private static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get|count|query)(\\p{Lu}.*?)??By");
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    private final Subject subject;
    private final Predicate predicate;

    public PartTree(String source, Class<?> domainClass) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull(domainClass, (String)"Domain class must not be null");
        Matcher matcher = PREFIX_TEMPLATE.matcher(source);
        if (!matcher.find()) {
            this.subject = new Subject(null);
            this.predicate = new Predicate(source, domainClass);
        } else {
            this.subject = new Subject(matcher.group(0));
            this.predicate = new Predicate(source.substring(matcher.group().length()), domainClass);
        }
    }

    @Override
    public Iterator<OrPart> iterator() {
        return this.predicate.iterator();
    }

    public Sort getSort() {
        OrderBySource orderBySource = this.predicate.getOrderBySource();
        return orderBySource == null ? null : orderBySource.toSort();
    }

    public boolean isDistinct() {
        return this.subject.isDistinct();
    }

    public Boolean isCountProjection() {
        return this.subject.isCountProjection();
    }

    public Iterable<Part> getParts() {
        ArrayList<Part> result = new ArrayList<Part>();
        for (OrPart orPart : this) {
            for (Part part : orPart) {
                result.add(part);
            }
        }
        return result;
    }

    public Iterable<Part> getParts(Part.Type type) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (Part part : this.getParts()) {
            if (!part.getType().equals((Object)type)) continue;
            result.add(part);
        }
        return result;
    }

    public String toString() {
        OrderBySource orderBySource = this.predicate.getOrderBySource();
        return String.format("%s%s", StringUtils.collectionToDelimitedString((Collection)this.predicate.nodes, (String)" or "), orderBySource == null ? "" : " " + orderBySource);
    }

    private static String[] split(String text, String keyword) {
        Pattern pattern = Pattern.compile(String.format(KEYWORD_TEMPLATE, keyword));
        return pattern.split(text);
    }

    private static class Predicate {
        private static final Pattern ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
        private static final String ORDER_BY = "OrderBy";
        private final List<OrPart> nodes = new ArrayList<OrPart>();
        private final OrderBySource orderBySource;
        private boolean alwaysIgnoreCase;

        public Predicate(String predicate, Class<?> domainClass) {
            String[] parts = PartTree.split(this.detectAndSetAllIgnoreCase(predicate), ORDER_BY);
            if (parts.length > 2) {
                throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
            }
            this.buildTree(parts[0], domainClass);
            this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1], domainClass) : null;
        }

        private String detectAndSetAllIgnoreCase(String predicate) {
            Matcher matcher = ALL_IGNORE_CASE.matcher(predicate);
            if (matcher.find()) {
                this.alwaysIgnoreCase = true;
                predicate = predicate.substring(0, matcher.start()) + predicate.substring(matcher.end(), predicate.length());
            }
            return predicate;
        }

        private void buildTree(String source, Class<?> domainClass) {
            String[] split;
            for (String part : split = PartTree.split(source, "Or")) {
                this.nodes.add(new OrPart(part, domainClass, this.alwaysIgnoreCase));
            }
        }

        public Iterator<OrPart> iterator() {
            return this.nodes.iterator();
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }
    }

    private static class Subject {
        private static final String DISTINCT = "Distinct";
        private static final Pattern COUNT_BY_TEMPLATE = Pattern.compile("^count(\\p{Lu}.*?)??By");
        private final boolean distinct;
        private final boolean count;

        public Subject(String subject) {
            this.distinct = subject == null ? false : subject.contains(DISTINCT);
            this.count = subject == null ? false : COUNT_BY_TEMPLATE.matcher(subject).find();
        }

        public boolean isCountProjection() {
            return this.count;
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }

    public static class OrPart
    implements Iterable<Part> {
        private final List<Part> children = new ArrayList<Part>();

        OrPart(String source, Class<?> domainClass, boolean alwaysIgnoreCase) {
            String[] split;
            for (String part : split = PartTree.split(source, "And")) {
                if (!StringUtils.hasText((String)part)) continue;
                this.children.add(new Part(part, domainClass, alwaysIgnoreCase));
            }
        }

        @Override
        public Iterator<Part> iterator() {
            return this.children.iterator();
        }

        public String toString() {
            return StringUtils.collectionToDelimitedString(this.children, (String)" and ");
        }
    }
}

