/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.data.web.SpringDataAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SortHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String DEFAULT_PARAMETER = "sort";
    private static final String DEFAULT_PROPERTY_DELIMITER = ",";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "_";
    private static final Sort DEFAULT_SORT = null;
    private static final String SORT_DEFAULTS_NAME = SortDefault.SortDefaults.class.getSimpleName();
    private static final String SORT_DEFAULT_NAME = SortDefault.class.getSimpleName();
    private Sort fallbackSort = DEFAULT_SORT;
    private String sortParameter = "sort";
    private String propertyDelimiter = ",";
    private String qualifierDelimiter = "_";
    boolean legacyMode = false;

    @Deprecated
    void setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    public void setSortParameter(String sortParameter) {
        Assert.hasText((String)sortParameter);
        this.sortParameter = sortParameter;
    }

    public void setPropertyDelimiter(String propertyDelimiter) {
        Assert.hasText((String)propertyDelimiter, (String)"Property delimiter must not be null or empty!");
        this.propertyDelimiter = propertyDelimiter;
    }

    public void setQualifierDelimiter(String qualifierDelimiter) {
        this.qualifierDelimiter = qualifierDelimiter == null ? DEFAULT_QUALIFIER_DELIMITER : qualifierDelimiter;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Sort.class.equals((Object)parameter.getParameterType());
    }

    public Sort resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String[] directionParameter = webRequest.getParameterValues(this.getSortParameter(parameter));
        if (directionParameter != null && directionParameter.length != 0) {
            return this.legacyMode ? this.parseLegacyParameterIntoSort((WebRequest)webRequest, parameter) : this.parseParameterIntoSort(directionParameter, this.propertyDelimiter);
        }
        return this.getDefaultFromAnnotationOrFallback(parameter);
    }

    private Sort getDefaultFromAnnotationOrFallback(MethodParameter parameter) {
        SortDefault.SortDefaults annotatedDefaults = (SortDefault.SortDefaults)parameter.getParameterAnnotation(SortDefault.SortDefaults.class);
        SortDefault annotatedDefault = (SortDefault)parameter.getParameterAnnotation(SortDefault.class);
        if (annotatedDefault != null && annotatedDefaults != null) {
            throw new IllegalArgumentException(String.format("Cannot use both @%s and @%s on parameter %s! Move %s into %s to define sorting order!", SORT_DEFAULTS_NAME, SORT_DEFAULT_NAME, parameter.toString(), SORT_DEFAULT_NAME, SORT_DEFAULTS_NAME));
        }
        if (annotatedDefault != null) {
            return this.appendOrCreateSortTo(annotatedDefault, null);
        }
        if (annotatedDefaults != null) {
            Sort sort = null;
            for (SortDefault currentAnnotatedDefault : annotatedDefaults.value()) {
                sort = this.appendOrCreateSortTo(currentAnnotatedDefault, sort);
            }
            return sort;
        }
        return this.fallbackSort;
    }

    private Sort appendOrCreateSortTo(SortDefault sortDefault, Sort sortOrNull) {
        String[] fields = (String[])SpringDataAnnotationUtils.getSpecificPropertyOrDefaultFromValue(sortDefault, DEFAULT_PARAMETER);
        if (fields.length == 0) {
            return null;
        }
        Sort sort = new Sort(sortDefault.direction(), fields);
        return sortOrNull == null ? sort : sortOrNull.and(sort);
    }

    protected String getSortParameter(MethodParameter parameter) {
        StringBuilder builder = new StringBuilder();
        if (parameter != null && parameter.hasParameterAnnotation(Qualifier.class)) {
            builder.append(((Qualifier)parameter.getParameterAnnotation(Qualifier.class)).value()).append(this.qualifierDelimiter);
        }
        return builder.append(this.sortParameter).toString();
    }

    private Sort parseLegacyParameterIntoSort(WebRequest request, MethodParameter parameter) {
        String property = this.getSortParameter(parameter);
        String fields = request.getParameter(property);
        String directions = request.getParameter(this.getLegacyDirectionParameter(parameter));
        return new Sort(Sort.Direction.fromStringOrNull(directions), fields.split(DEFAULT_PROPERTY_DELIMITER));
    }

    protected String getLegacyDirectionParameter(MethodParameter parameter) {
        return this.getSortParameter(parameter) + ".dir";
    }

    Sort parseParameterIntoSort(String[] source, String delimiter) {
        ArrayList<Sort.Order> allOrders = new ArrayList<Sort.Order>();
        for (String part : source) {
            if (part == null) continue;
            String[] elements = part.split(delimiter);
            Sort.Direction direction = elements.length == 0 ? null : Sort.Direction.fromStringOrNull(elements[elements.length - 1]);
            for (int i = 0; i < elements.length; ++i) {
                String property;
                if (i == elements.length - 1 && direction != null || !StringUtils.hasText((String)(property = elements[i]))) continue;
                allOrders.add(new Sort.Order(direction, property));
            }
        }
        return allOrders.isEmpty() ? null : new Sort(allOrders);
    }

    protected List<String> foldIntoExpressions(Sort sort) {
        ArrayList<String> expressions = new ArrayList<String>();
        ExpressionBuilder builder = null;
        for (Sort.Order order : sort) {
            Sort.Direction direction = order.getDirection();
            if (builder == null) {
                builder = new ExpressionBuilder(direction);
            } else if (!builder.hasSameDirectionAs(order)) {
                builder.dumpExpressionIfPresentInto(expressions);
                builder = new ExpressionBuilder(direction);
            }
            builder.add(order.getProperty());
        }
        return builder == null ? Collections.emptyList() : builder.dumpExpressionIfPresentInto(expressions);
    }

    protected List<String> legacyFoldExpressions(Sort sort) {
        ArrayList<String> expressions = new ArrayList<String>();
        ExpressionBuilder builder = null;
        for (Sort.Order order : sort) {
            Sort.Direction direction = order.getDirection();
            if (builder == null) {
                builder = new ExpressionBuilder(direction);
            } else if (!builder.hasSameDirectionAs(order)) {
                throw new IllegalArgumentException(String.format("%s in legacy configuration only supports a single direction to sort by!", this.getClass().getSimpleName()));
            }
            builder.add(order.getProperty());
        }
        return builder == null ? Collections.emptyList() : builder.dumpExpressionIfPresentInto(expressions);
    }

    public void setFallbackSort(Sort fallbackSort) {
        this.fallbackSort = fallbackSort;
    }

    class ExpressionBuilder {
        private final List<String> elements = new ArrayList<String>();
        private final Sort.Direction direction;

        public ExpressionBuilder(Sort.Direction direction) {
            Assert.notNull((Object)((Object)direction), (String)"Direction must not be null!");
            this.direction = direction;
        }

        public boolean hasSameDirectionAs(Sort.Order order) {
            return this.direction == order.getDirection();
        }

        public void add(String property) {
            this.elements.add(property);
        }

        public List<String> dumpExpressionIfPresentInto(List<String> expressions) {
            if (this.elements.isEmpty()) {
                return expressions;
            }
            if (SortHandlerMethodArgumentResolver.this.legacyMode) {
                expressions.add(StringUtils.collectionToDelimitedString(this.elements, (String)SortHandlerMethodArgumentResolver.this.propertyDelimiter));
                expressions.add(this.direction.name().toLowerCase());
            } else {
                this.elements.add(this.direction.name().toLowerCase());
                expressions.add(StringUtils.collectionToDelimitedString(this.elements, (String)SortHandlerMethodArgumentResolver.this.propertyDelimiter));
            }
            return expressions;
        }
    }
}

