/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.authentication;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class UserCredentials {
    public static final UserCredentials NO_CREDENTIALS = new UserCredentials(null, null);
    private final String username;
    private final String password;

    public UserCredentials(String username, String password) {
        this.username = StringUtils.hasText((String)username) ? username : null;
        this.password = StringUtils.hasText((String)password) ? password : null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getObfuscatedPassword() {
        if (!this.hasPassword()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (this.password.length() < 3) {
            for (int i = this.password.length(); i != 0; --i) {
                builder.append("*");
            }
            return builder.toString();
        }
        builder.append(this.password.charAt(0));
        for (int i = this.password.length() - 2; i != 0; --i) {
            builder.append("*");
        }
        return builder.append(this.password.substring(this.password.length() - 1)).toString();
    }

    public String toString() {
        return String.format("username = [%s], password = [%s]", this.username, this.getObfuscatedPassword());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        UserCredentials that = (UserCredentials)obj;
        return ObjectUtils.nullSafeEquals((Object)this.username, (Object)that.username) && ObjectUtils.nullSafeEquals((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.username);
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.password);
    }
}

