/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;

class KotlinDefaultMask {
    private final int[] defaulting;

    public void forEach(IntConsumer maskCallback) {
        for (int i : this.defaulting) {
            maskCallback.accept(i);
        }
    }

    public static KotlinDefaultMask from(KFunction<?> function, Predicate<KParameter> isPresent) {
        ArrayList<Integer> masks = new ArrayList<Integer>();
        int index = 0;
        int mask = 0;
        List parameters = function.getParameters();
        for (KParameter parameter : parameters) {
            if (index != 0 && index % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            if (parameter.isOptional() && !isPresent.test(parameter)) {
                mask |= 1 << index % 32;
            }
            if (parameter.getKind() != KParameter.Kind.VALUE) continue;
            ++index;
        }
        masks.add(mask);
        return new KotlinDefaultMask(masks.stream().mapToInt(i -> i).toArray());
    }

    private KotlinDefaultMask(int[] defaulting) {
        this.defaulting = defaulting;
    }
}

