/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializerBase;
import com.fasterxml.jackson.databind.util.StdConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.geo.GeoModule;
import org.springframework.data.web.PagedModel;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.SpringDataJacksonModules;
import org.springframework.data.web.config.SpringDataWebSettings;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SpringDataJacksonConfiguration
implements SpringDataJacksonModules {
    @Nullable
    @Autowired(required=false)
    SpringDataWebSettings settings;

    @Bean
    public GeoModule jacksonGeoModule() {
        return new GeoModule();
    }

    @Bean
    public PageModule pageModule() {
        return new PageModule(this.settings);
    }

    public static class PageModule
    extends SimpleModule {
        private static final long serialVersionUID = 275254460581626332L;
        private static final String UNPAGED_TYPE_NAME = "org.springframework.data.domain.Unpaged";
        private static final Class<?> UNPAGED_TYPE = ClassUtils.resolveClassName((String)"org.springframework.data.domain.Unpaged", (ClassLoader)PageModule.class.getClassLoader());

        public PageModule(@Nullable SpringDataWebSettings settings) {
            this.addSerializer(UNPAGED_TYPE, (JsonSerializer)new UnpagedAsInstanceSerializer());
            if (settings != null && settings.pageSerializationMode() == EnableSpringDataWebSupport.PageSerializationMode.DIRECT) {
                this.setMixInAnnotation(PageImpl.class, WarningMixing.class);
            } else {
                this.setMixInAnnotation(PageImpl.class, WrappingMixing.class);
            }
        }

        static class UnpagedAsInstanceSerializer
        extends ToStringSerializerBase {
            private static final long serialVersionUID = -1213451755610144637L;

            public UnpagedAsInstanceSerializer() {
                super(Object.class);
            }

            public String valueToString(@Nullable Object value) {
                return "INSTANCE";
            }
        }

        @JsonSerialize(converter=PlainPageSerializationWarning.class)
        abstract class WarningMixing {
            WarningMixing() {
            }
        }

        @JsonSerialize(converter=PageModelConverter.class)
        abstract class WrappingMixing {
            WrappingMixing() {
            }
        }

        static class PlainPageSerializationWarning
        extends StdConverter<Page<?>, Page<?>> {
            private static final Logger LOGGER = LoggerFactory.getLogger(PlainPageSerializationWarning.class);
            private static final String MESSAGE = "Serializing PageImpl instances as-is is not supported, meaning that there is no guarantee about the stability of the resulting JSON structure!\n\tFor a stable JSON structure, please use Spring Data's PagedModel (globally via @EnableSpringDataWebSupport(pageSerializationMode = VIA_DTO))\n\tor Spring HATEOAS and Spring Data's PagedResourcesAssembler as documented in https://docs.spring.io/spring-data/commons/reference/repositories/core-extensions.html#core.web.pageables.\n";
            private boolean warningRendered = false;

            PlainPageSerializationWarning() {
            }

            @Nullable
            public Page<?> convert(@Nullable Page<?> value) {
                if (!this.warningRendered) {
                    this.warningRendered = true;
                    LOGGER.warn(MESSAGE);
                }
                return value;
            }
        }

        static class PageModelConverter
        extends StdConverter<Page<?>, PagedModel<?>> {
            PageModelConverter() {
            }

            @Nullable
            public PagedModel<?> convert(@Nullable Page<?> value) {
                return value == null ? null : new PagedModel(value);
            }
        }
    }
}

