/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class WindowImpl<T>
implements Window<T> {
    private final List<T> items;
    private final IntFunction<? extends ScrollPosition> positionFunction;
    private final boolean hasNext;

    WindowImpl(List<T> items, IntFunction<? extends ScrollPosition> positionFunction, boolean hasNext) {
        Assert.notNull(items, (String)"List of items must not be null");
        Assert.notNull(positionFunction, (String)"Position function must not be null");
        this.items = items;
        this.positionFunction = positionFunction;
        this.hasNext = hasNext;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public List<T> getContent() {
        return this.items;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public ScrollPosition positionAt(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.positionFunction.apply(index);
    }

    @Override
    public <U> Window<U> map(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null");
        return new WindowImpl(this.stream().map(converter).collect(Collectors.toList()), this.positionFunction, this.hasNext);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowImpl that = (WindowImpl)o;
        return ObjectUtils.nullSafeEquals(this.items, that.items) && ObjectUtils.nullSafeEquals(this.positionFunction, that.positionFunction) && ObjectUtils.nullSafeEquals((Object)this.hasNext, (Object)that.hasNext);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.items);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.positionFunction);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.hasNext);
        return result;
    }

    public String toString() {
        return "Window " + String.valueOf(this.items);
    }
}

