/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.data.aot.AotContext;
import org.springframework.util.ClassUtils;

class DefaultAotContext
implements AotContext {
    private final ConfigurableListableBeanFactory factory;
    private final Environment environment;

    public DefaultAotContext(BeanFactory beanFactory, Environment environment) {
        DefaultListableBeanFactory defaultListableBeanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory cbf = (ConfigurableListableBeanFactory)beanFactory;
            defaultListableBeanFactory = cbf;
        } else {
            defaultListableBeanFactory = new DefaultListableBeanFactory(beanFactory);
        }
        this.factory = defaultListableBeanFactory;
        this.environment = environment;
    }

    @Override
    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.factory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public AotContext.TypeIntrospector introspectType(String typeName) {
        return new DefaultTypeIntrospector(typeName);
    }

    @Override
    public AotContext.IntrospectedBeanDefinition introspectBeanDefinition(String beanName) {
        return new DefaultIntrospectedBeanDefinition(beanName);
    }

    class DefaultTypeIntrospector
    implements AotContext.TypeIntrospector {
        private final String typeName;

        DefaultTypeIntrospector(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public boolean isTypePresent() {
            return ClassUtils.isPresent((String)this.typeName, (ClassLoader)DefaultAotContext.this.getClassLoader());
        }

        @Override
        public Class<?> resolveRequiredType() throws TypeNotPresentException {
            try {
                return ClassUtils.forName((String)this.typeName, (ClassLoader)DefaultAotContext.this.getClassLoader());
            }
            catch (ClassNotFoundException cause) {
                throw new TypeNotPresentException(this.typeName, cause);
            }
        }

        @Override
        public Optional<Class<?>> resolveType() {
            return this.isTypePresent() ? Optional.of(this.resolveRequiredType()) : Optional.empty();
        }

        @Override
        public boolean hasBean() {
            return !this.getBeanNames().isEmpty();
        }

        @Override
        public List<String> getBeanNames() {
            return this.isTypePresent() ? Arrays.asList(DefaultAotContext.this.factory.getBeanNamesForType(this.resolveRequiredType())) : Collections.emptyList();
        }
    }

    class DefaultIntrospectedBeanDefinition
    implements AotContext.IntrospectedBeanDefinition {
        private final String beanName;

        DefaultIntrospectedBeanDefinition(String beanName) {
            this.beanName = beanName;
        }

        @Override
        public boolean isPresent() {
            return DefaultAotContext.this.factory.containsBeanDefinition(this.beanName);
        }

        @Override
        public boolean isFactoryBean() {
            return DefaultAotContext.this.factory.isFactoryBean(this.beanName);
        }

        @Override
        public BeanDefinition getBeanDefinition() throws NoSuchBeanDefinitionException {
            return DefaultAotContext.this.factory.getBeanDefinition(this.beanName);
        }

        @Override
        public RootBeanDefinition getRootBeanDefinition() throws NoSuchBeanDefinitionException {
            BeanDefinition beanDefinition = this.getBeanDefinition();
            if (beanDefinition instanceof RootBeanDefinition) {
                RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
                return rootBeanDefinition;
            }
            throw new IllegalStateException(String.format("%s is not a root bean", this.beanName));
        }

        @Override
        public @Nullable Class<?> resolveType() {
            return DefaultAotContext.this.factory.getType(this.beanName, false);
        }
    }
}

