/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.jspecify.annotations.Nullable;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;

public class CachingValueExpressionEvaluatorFactory
implements ValueEvaluationContextProvider {
    private final ConcurrentLruCache<String, ValueExpression> expressionCache;
    private final EnvironmentCapable environmentProvider;
    private final EvaluationContextProvider evaluationContextProvider;

    public CachingValueExpressionEvaluatorFactory(ExpressionParser expressionParser, EnvironmentCapable environmentProvider, EvaluationContextProvider evaluationContextProvider) {
        this(expressionParser, environmentProvider, evaluationContextProvider, 256);
    }

    public CachingValueExpressionEvaluatorFactory(ExpressionParser expressionParser, EnvironmentCapable environmentProvider, EvaluationContextProvider evaluationContextProvider, int cacheSize) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null");
        ValueExpressionParser parser = ValueExpressionParser.create(() -> expressionParser);
        this.expressionCache = new ConcurrentLruCache(cacheSize, parser::parse);
        this.environmentProvider = environmentProvider;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    public ValueEvaluationContext getEvaluationContext(@Nullable Object rootObject) {
        return ValueEvaluationContext.of(this.environmentProvider.getEnvironment(), this.evaluationContextProvider.getEvaluationContext(rootObject));
    }

    @Override
    public ValueEvaluationContext getEvaluationContext(@Nullable Object rootObject, ExpressionDependencies dependencies) {
        return ValueEvaluationContext.of(this.environmentProvider.getEnvironment(), this.evaluationContextProvider.getEvaluationContext(rootObject, dependencies));
    }

    public ValueExpressionEvaluator create(final Object source) {
        return new ValueExpressionEvaluator(){
            final /* synthetic */ CachingValueExpressionEvaluatorFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public <T> @Nullable T evaluate(String expression) {
                ValueExpression valueExpression = (ValueExpression)this.this$0.expressionCache.get((Object)expression);
                return (T)valueExpression.evaluate(this.this$0.getEvaluationContext(source, valueExpression.getExpressionDependencies()));
            }
        };
    }
}

