/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.annotation.QueryAnnotation;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class RepositoryInformationSupport
implements RepositoryInformation {
    private final Supplier<RepositoryMetadata> metadata;
    private final Supplier<Class<?>> repositoryBaseClass;
    private final Supplier<DefaultQueryMethods> queryMethods;

    public RepositoryInformationSupport(Supplier<RepositoryMetadata> metadata, Supplier<Class<?>> repositoryBaseClass) {
        Assert.notNull(metadata, (String)"Repository metadata must not be null");
        Assert.notNull(repositoryBaseClass, (String)"Repository base class must not be null");
        this.metadata = Lazy.of(metadata);
        this.repositoryBaseClass = Lazy.of(repositoryBaseClass);
        this.queryMethods = Lazy.of(this::calculateQueryMethods);
    }

    @Override
    public List<Method> getQueryMethods() {
        return this.queryMethods.get().methods;
    }

    @Override
    public Class<?> getIdType() {
        return this.getMetadata().getIdType();
    }

    @Override
    public Class<?> getDomainType() {
        return this.getMetadata().getDomainType();
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.getMetadata().getRepositoryInterface();
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        return this.getMetadata().getReturnType(method);
    }

    @Override
    public Class<?> getReturnedDomainClass(Method method) {
        return this.getMetadata().getReturnedDomainClass(method);
    }

    @Override
    public TypeInformation<?> getReturnedDomainTypeInformation(Method method) {
        return this.getMetadata().getReturnedDomainTypeInformation(method);
    }

    @Override
    public CrudMethods getCrudMethods() {
        return this.getMetadata().getCrudMethods();
    }

    @Override
    public boolean isPagingRepository() {
        return this.getMetadata().isPagingRepository();
    }

    @Override
    public Set<Class<?>> getAlternativeDomainTypes() {
        return this.getMetadata().getAlternativeDomainTypes();
    }

    @Override
    public boolean isReactiveRepository() {
        return this.getMetadata().isReactiveRepository();
    }

    @Override
    public Class<?> getRepositoryBaseClass() {
        return this.repositoryBaseClass.get();
    }

    @Override
    public boolean isQueryMethod(Method method) {
        return this.queryMethods.get().isQueryMethod(method);
    }

    @Override
    public TypeInformation<?> getDomainTypeInformation() {
        return this.getMetadata().getDomainTypeInformation();
    }

    @Override
    public TypeInformation<?> getIdTypeInformation() {
        return this.getMetadata().getIdTypeInformation();
    }

    @Override
    public boolean hasCustomMethod() {
        return this.queryMethods.get().hasCustomMethod;
    }

    @Override
    public boolean hasQueryMethods() {
        return this.queryMethods.get().hasQueryMethod;
    }

    protected boolean isQueryAnnotationPresentOn(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations.length == 0) {
            return false;
        }
        return MergedAnnotations.from((Annotation[])annotations).isPresent(QueryAnnotation.class);
    }

    protected boolean isQueryMethodCandidate(Method method) {
        if (method.isBridge() || method.isDefault() || Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (this.isCustomMethod(method)) {
            return false;
        }
        if (this.isQueryAnnotationPresentOn(method)) {
            return true;
        }
        return !this.isBaseClassMethod(method);
    }

    protected RepositoryMetadata getMetadata() {
        return this.metadata.get();
    }

    private DefaultQueryMethods calculateQueryMethods() {
        Class<?> repositoryInterface = this.getRepositoryInterface();
        Method[] methods = repositoryInterface.getMethods();
        ArrayList<Method> queryMethods = new ArrayList<Method>(methods.length);
        for (Method method : methods) {
            Method msm = ClassUtils.getMostSpecificMethod((Method)method, repositoryInterface);
            if (!this.isQueryMethodCandidate(method)) continue;
            queryMethods.add(msm);
        }
        return new DefaultQueryMethods(queryMethods, this.calculateHasCustomMethod(repositoryInterface, methods));
    }

    private boolean calculateHasCustomMethod(Class<?> repositoryInterface, Method[] methods) {
        if (RepositoryInformationSupport.isGenericRepositoryInterface(repositoryInterface)) {
            return false;
        }
        for (Method method : methods) {
            if (!this.isCustomMethod(method) || this.isBaseClassMethod(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGenericRepositoryInterface(Class<?> ifc) {
        return Repository.class.equals(ifc);
    }

    @Contract(value="null -> false")
    public static boolean isGenericRepositoryInterface(@Nullable String interfaceName) {
        return Repository.class.getName().equals(interfaceName);
    }

    private static class DefaultQueryMethods {
        private final List<Method> methods;
        private final Set<Method> methodSet;
        private final boolean hasCustomMethod;
        private final boolean hasQueryMethod;

        DefaultQueryMethods(List<Method> methods, boolean hasCustomMethod) {
            this.methods = Collections.unmodifiableList(methods);
            this.methodSet = new HashSet<Method>(methods);
            this.hasCustomMethod = hasCustomMethod;
            this.hasQueryMethod = !methods.isEmpty();
        }

        public boolean isQueryMethod(Method method) {
            return this.methodSet.contains(method);
        }
    }
}

