/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.couchbase.core.convert.CouchbaseTypeMapper;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;

public class DefaultCouchbaseTypeMapper
extends DefaultTypeMapper<CouchbaseDocument>
implements CouchbaseTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private final String typeKey;

    public DefaultCouchbaseTypeMapper(String typeKey) {
        super((TypeAliasAccessor)new CouchbaseDocumentTypeAliasAccessor(typeKey));
        this.typeKey = typeKey;
    }

    @Override
    public String getTypeKey() {
        return this.typeKey;
    }

    public static final class CouchbaseDocumentTypeAliasAccessor
    implements TypeAliasAccessor<CouchbaseDocument> {
        private final String typeKey;

        public CouchbaseDocumentTypeAliasAccessor(String typeKey) {
            this.typeKey = typeKey;
        }

        public Object readAliasFrom(CouchbaseDocument source) {
            return source.get(this.typeKey);
        }

        public void writeTypeTo(CouchbaseDocument sink, Object alias) {
            if (this.typeKey != null) {
                sink.put(this.typeKey, alias);
            }
        }
    }
}

