/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;

public abstract class PointInShapeEvaluator {
    public abstract boolean pointInPolygon(Point var1, Polygon var2);

    public abstract boolean pointInPolygon(Point var1, Point ... var2);

    public abstract boolean pointInCircle(Point var1, Circle var2);

    public abstract boolean pointInCircle(Point var1, Point var2, Distance var3);

    public <T> List<T> removeFalsePositives(Collection<? extends T> boundingBoxResults, Converter<T, Point> locationExtractor, Polygon polygon) {
        ArrayList<T> result = new ArrayList<T>(boundingBoxResults.size());
        for (T boxResult : boundingBoxResults) {
            Point p = (Point)locationExtractor.convert(boxResult);
            if (!this.pointInPolygon(p, polygon)) continue;
            result.add(boxResult);
        }
        result.trimToSize();
        return result;
    }

    public <T> List<T> removeFalsePositives(Collection<? extends T> boundingBoxResults, Converter<T, Point> locationExtractor, Circle circle) {
        ArrayList<T> result = new ArrayList<T>(boundingBoxResults.size());
        for (T boxResult : boundingBoxResults) {
            Point p = (Point)locationExtractor.convert(boxResult);
            if (!this.pointInCircle(p, circle)) continue;
            result.add(boxResult);
        }
        result.trimToSize();
        return result;
    }

    public <T> List<T> removeFalsePositives(Collection<? extends T> boundingBoxResults, Converter<T, Point> locationExtractor, Point ... polygon) {
        ArrayList<T> result = new ArrayList<T>(boundingBoxResults.size());
        for (T boxResult : boundingBoxResults) {
            Point p = (Point)locationExtractor.convert(boxResult);
            if (!this.pointInPolygon(p, polygon)) continue;
            result.add(boxResult);
        }
        result.trimToSize();
        return result;
    }

    public <T> List<T> removeFalsePositives(Collection<? extends T> boundingBoxResults, Converter<T, Point> locationExtractor, Point center, Distance radius) {
        ArrayList<T> result = new ArrayList<T>(boundingBoxResults.size());
        for (T boxResult : boundingBoxResults) {
            Point p = (Point)locationExtractor.convert(boxResult);
            if (!this.pointInCircle(p, center, radius)) continue;
            result.add(boxResult);
        }
        result.trimToSize();
        return result;
    }
}

