/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.IndexManager;
import org.springframework.data.couchbase.repository.support.ReactiveCouchbaseRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class ReactiveCouchbaseRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private ReactiveRepositoryOperationsMapping couchbaseOperationsMapping;
    private IndexManager indexManager;

    public ReactiveCouchbaseRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setCouchbaseOperations(RxJavaCouchbaseOperations couchbaseOperationsMapping) {
        this.setCouchbaseOperationsMapping(new ReactiveRepositoryOperationsMapping(couchbaseOperationsMapping));
    }

    public void setCouchbaseOperationsMapping(ReactiveRepositoryOperationsMapping couchbaseOperationsMapping) {
        this.couchbaseOperationsMapping = couchbaseOperationsMapping;
        this.setMappingContext(couchbaseOperationsMapping.getMappingContext());
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.couchbaseOperationsMapping, this.indexManager);
    }

    protected ReactiveCouchbaseRepositoryFactory getFactoryInstance(ReactiveRepositoryOperationsMapping couchbaseOperationsMapping, IndexManager indexManager) {
        return new ReactiveCouchbaseRepositoryFactory(couchbaseOperationsMapping, indexManager);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.couchbaseOperationsMapping, (String)"operationsMapping must not be null!");
        Assert.notNull((Object)this.indexManager, (String)"indexManager must not be null!");
    }
}

