/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.couchbase.config.CouchbaseConfigurationSupport;
import org.springframework.data.couchbase.config.CouchbaseConfigurer;
import org.springframework.data.couchbase.core.RxJavaCouchbaseTemplate;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;

@Configuration
public abstract class AbstractReactiveCouchbaseDataConfiguration
extends CouchbaseConfigurationSupport {
    protected abstract CouchbaseConfigurer couchbaseConfigurer();

    @Bean(name={"rxjava1CouchbaseTemplate"})
    public RxJavaCouchbaseTemplate reactiveCouchbaseTemplate() throws Exception {
        RxJavaCouchbaseTemplate template = new RxJavaCouchbaseTemplate(this.couchbaseConfigurer().couchbaseClusterInfo(), this.couchbaseConfigurer().couchbaseClient(), this.mappingCouchbaseConverter(), this.translationService());
        template.setDefaultConsistency(this.getDefaultConsistency());
        return template;
    }

    @Bean(name={"reactiveCouchbaseRepositoryOperationsMapping"})
    public ReactiveRepositoryOperationsMapping reactiveRepositoryOperationsMapping(RxJavaCouchbaseTemplate couchbaseTemplate) throws Exception {
        ReactiveRepositoryOperationsMapping baseMapping = new ReactiveRepositoryOperationsMapping(couchbaseTemplate);
        this.configureReactiveRepositoryOperationsMapping(baseMapping);
        return baseMapping;
    }

    protected void configureReactiveRepositoryOperationsMapping(ReactiveRepositoryOperationsMapping mapping) {
    }
}

