/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.monitor;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.bucket.BucketInfo;
import java.net.InetAddress;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Client Information")
public class ClientInfo {
    private final Bucket bucket;
    private final BucketInfo info;

    public ClientInfo(Bucket bucket) {
        this.bucket = bucket;
        this.info = bucket.bucketManager().info();
    }

    @ManagedAttribute(description="Hostnames of connected nodes")
    public String getHostNames() {
        StringBuilder result = new StringBuilder();
        for (InetAddress node : this.info.nodeList()) {
            result.append(node.toString()).append(",");
        }
        return result.toString();
    }

    @ManagedAttribute(description="Number of connected nodes")
    public int getNumberOfNodes() {
        return this.info.nodeCount();
    }
}

