/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.monitor;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.bucket.BucketInfo;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.client.RestTemplate;

@ManagedResource(description="Cluster Information")
public class ClusterInfo {
    private final RestTemplate template = new RestTemplate();
    private final Bucket bucket;
    private final BucketInfo info;

    public ClusterInfo(Bucket bucket) {
        this.bucket = bucket;
        this.info = bucket.bucketManager().info();
    }

    @ManagedMetric(description="Total RAM assigned")
    public long getTotalRAMAssigned() {
        return this.convertPotentialLong(this.parseStorageTotals().get("ram").get("total"));
    }

    @ManagedMetric(description="Total RAM used")
    public long getTotalRAMUsed() {
        return this.convertPotentialLong(this.parseStorageTotals().get("ram").get("used"));
    }

    @ManagedMetric(description="Total Disk Space assigned")
    public long getTotalDiskAssigned() {
        return this.convertPotentialLong(this.parseStorageTotals().get("hdd").get("total"));
    }

    @ManagedMetric(description="Total Disk Space used")
    public long getTotalDiskUsed() {
        return this.convertPotentialLong(this.parseStorageTotals().get("hdd").get("used"));
    }

    @ManagedMetric(description="Total Disk Space free")
    public long getTotalDiskFree() {
        return this.convertPotentialLong(this.parseStorageTotals().get("hdd").get("free"));
    }

    @ManagedAttribute(description="Cluster is Balanced")
    public boolean getIsBalanced() {
        return (Boolean)this.fetchPoolInfo().get("balanced");
    }

    @ManagedAttribute(description="Rebalance Status")
    public String getRebalanceStatus() {
        return (String)this.fetchPoolInfo().get("rebalanceStatus");
    }

    @ManagedAttribute(description="Maximum Available Buckets")
    public int getMaxBuckets() {
        return (Integer)this.fetchPoolInfo().get("maxBucketCount");
    }

    private long convertPotentialLong(Object value) {
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalStateException("Cannot convert value to long: " + value);
    }

    protected String randomAvailableHostname() {
        List available = this.info.nodeList();
        Collections.shuffle(available);
        return ((InetAddress)available.get(0)).getHostName();
    }

    private HashMap<String, Object> fetchPoolInfo() {
        return (HashMap)this.template.getForObject("http://" + this.randomAvailableHostname() + ":8091/pools/default", HashMap.class, new Object[0]);
    }

    private HashMap<String, HashMap> parseStorageTotals() {
        HashMap<String, Object> stats = this.fetchPoolInfo();
        return (HashMap)stats.get("storageTotals");
    }
}

