/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.document.json.JsonArray;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;

public class GeoUtils {
    public static double[] getBoundingBoxForNear(Point origin, Distance distance) {
        if (origin == null || distance == null) {
            throw new NullPointerException("Origin and distance required");
        }
        double maxDistance = Math.abs(distance.getNormalizedValue());
        double xMin = origin.getX() - maxDistance;
        double yMin = origin.getY() - maxDistance;
        double xMax = origin.getX() + maxDistance;
        double yMax = origin.getY() + maxDistance;
        return new double[]{xMin, yMin, xMax, yMax};
    }

    public static void convertPointsTo2DRanges(JsonArray startRange, JsonArray endRange, boolean isBoundingBox, Point ... points) {
        if (points == null || points.length == 0) {
            throw new IllegalArgumentException("Needs points to convert");
        }
        if (isBoundingBox) {
            if (points.length != 2) {
                throw new IllegalArgumentException("Bounding box must be made of 2 points");
            }
            if (points[0].getX() > points[1].getX() || points[0].getY() > points[1].getY()) {
                throw new IllegalArgumentException("Bounding box must have point A on the lower left of point B");
            }
            startRange.add(points[0].getX()).add(points[0].getY());
            endRange.add(points[1].getX()).add(points[1].getY());
        } else {
            double xMin = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (Point point : points) {
                xMin = point.getX() < xMin ? point.getX() : xMin;
                xMax = point.getX() > xMax ? point.getX() : xMax;
                yMin = point.getY() < yMin ? point.getY() : yMin;
                yMax = point.getY() > yMax ? point.getY() : yMax;
            }
            startRange.add(xMin).add(yMin);
            endRange.add(xMax).add(yMax);
        }
    }

    public static void convertShapeTo2DRanges(JsonArray startRange, JsonArray endRange, Shape shape) {
        if (shape instanceof Box) {
            Box box = (Box)shape;
            startRange.add(box.getFirst().getX()).add(box.getFirst().getY());
            endRange.add(box.getSecond().getX()).add(box.getSecond().getY());
        } else if (shape instanceof Polygon) {
            double xMin = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (Point point : (Polygon)shape) {
                xMin = point.getX() < xMin ? point.getX() : xMin;
                xMax = point.getX() > xMax ? point.getX() : xMax;
                yMin = point.getY() < yMin ? point.getY() : yMin;
                yMax = point.getY() > yMax ? point.getY() : yMax;
            }
            startRange.add(xMin).add(yMin);
            endRange.add(xMax).add(yMax);
        } else if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            Point center = circle.getCenter();
            double radius = circle.getRadius().getNormalizedValue();
            double xMin = center.getX() - radius;
            double xMax = center.getX() + radius;
            double yMin = center.getY() - radius;
            double yMax = center.getY() + radius;
            startRange.add(xMin).add(yMin);
            endRange.add(xMax).add(yMax);
        } else {
            throw new IllegalArgumentException("Unsupported shape " + shape.getClass().getName());
        }
    }
}

