/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.kv.UpsertOptions;
import java.util.Collection;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveUpsertByIdOperation;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveUpsertByIdOperationSupport
implements ReactiveUpsertByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    public ReactiveUpsertByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveUpsertByIdOperation.ReactiveUpsertById<T> upsertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveUpsertByIdSupport<T>(this.template, domainType, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE);
    }

    static class ReactiveUpsertByIdSupport<T>
    implements ReactiveUpsertByIdOperation.ReactiveUpsertById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;

        ReactiveUpsertByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String collection, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
        }

        @Override
        public Mono<T> one(T object) {
            return Mono.just(object).flatMap(o -> {
                CouchbaseDocument converted = this.template.support().encodeEntity(o);
                return this.template.getCollection(this.collection).reactive().upsert(converted.getId(), converted.export(), this.buildUpsertOptions()).map(result -> {
                    this.template.support().applyUpdatedCas(object, result.cas());
                    return o;
                });
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        private UpsertOptions buildUpsertOptions() {
            UpsertOptions options = UpsertOptions.upsertOptions();
            if (this.persistTo != PersistTo.NONE || this.replicateTo != ReplicateTo.NONE) {
                options.durability(this.persistTo, this.replicateTo);
            } else if (this.durabilityLevel != DurabilityLevel.NONE) {
                options.durability(this.durabilityLevel);
            }
            return options;
        }

        @Override
        public ReactiveUpsertByIdOperation.TerminatingUpsertById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, collection, this.persistTo, this.replicateTo, this.durabilityLevel);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdWithCollection<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.collection, this.persistTo, this.replicateTo, durabilityLevel);
        }

        @Override
        public ReactiveUpsertByIdOperation.UpsertByIdWithCollection<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveUpsertByIdSupport<T>(this.template, this.domainType, this.collection, persistTo, replicateTo, this.durabilityLevel);
        }
    }
}

