/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonValue;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.OldN1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.ReactiveAbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

public class ReactivePartTreeN1qlBasedQuery
extends ReactiveAbstractN1qlBasedQuery {
    private final PartTree partTree;
    private JsonValue placeHolderValues;

    public ReactivePartTreeN1qlBasedQuery(CouchbaseQueryMethod queryMethod, ReactiveCouchbaseOperations operations) {
        super(queryMethod, operations);
        this.partTree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.placeHolderValues;
    }

    @Override
    protected N1QLExpression getExpression(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        String bucketName = this.getCouchbaseOperations().getBucketName();
        N1QLExpression bucket = N1qlUtils.escapedBucket(bucketName);
        N1QLExpression select = this.partTree.isCountProjection() ? N1QLExpression.select(N1QLExpression.count(N1QLExpression.x("*"))) : N1qlUtils.createSelectClauseForEntity(bucketName, returnedType, this.getCouchbaseOperations().getConverter());
        N1QLExpression selectFrom = select.from(bucket);
        OldN1qlQueryCreator queryCreator = new OldN1qlQueryCreator(this.partTree, accessor, selectFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        N1QLExpression selectFromWhereOrderBy = (N1QLExpression)queryCreator.createQuery();
        this.placeHolderValues = queryCreator.getPlaceHolderValues();
        if (this.partTree.isLimiting()) {
            return selectFromWhereOrderBy.limit(this.partTree.getMaxResults());
        }
        return selectFromWhereOrderBy;
    }
}

