/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadata;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveCouchbaseRepository<T, ID>
implements ReactiveCouchbaseRepository<T, ID> {
    private final ReactiveCouchbaseOperations operations;
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private CrudMethodMetadata crudMethodMetadata;

    public SimpleReactiveCouchbaseRepository(CouchbaseEntityInformation<T, String> entityInformation, ReactiveCouchbaseOperations operations) {
        Assert.notNull((Object)operations, (String)"ReactiveCouchbaseOperations must not be null!");
        Assert.notNull(entityInformation, (String)"CouchbaseEntityInformation must not be null!");
        this.entityInformation = entityInformation;
        this.operations = operations;
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.upsertById(this.entityInformation.getJavaType()).one(entity);
    }

    public Flux<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return this.operations.upsertById(this.entityInformation.getJavaType()).all(Streamable.of(entities).toList());
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Iterable of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        return this.operations.findById(this.entityInformation.getJavaType()).one(id.toString());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.existsById().one(id.toString());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        return Mono.from(publisher).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        List<String> convertedIds = Streamable.of(ids).stream().map(Objects::toString).collect(Collectors.toList());
        return this.operations.findById(this.entityInformation.getJavaType()).all(convertedIds);
    }

    public Flux<T> findAllById(Publisher<ID> entityStream) {
        Assert.notNull(entityStream, (String)"The given entityStream must not be null!");
        return Flux.from(entityStream).flatMap(this::findById);
    }

    public Mono<Void> deleteById(ID id) {
        return this.operations.removeById().one(id.toString()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(this::deleteById);
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.removeById().one((String)this.entityInformation.getId(entity)).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        return this.operations.removeById().all(Streamable.of(entities).map(arg_0 -> this.entityInformation.getId(arg_0)).toList()).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::delete).single();
    }

    public Mono<Long> count() {
        return this.operations.findByQuery(this.entityInformation.getJavaType()).consistentWith(this.buildQueryScanConsistency()).count();
    }

    public Mono<Void> deleteAll() {
        return this.operations.removeByQuery(this.entityInformation.getJavaType()).all().then();
    }

    protected CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    private Flux<T> findAll(Query query) {
        return this.operations.findByQuery(this.entityInformation.getJavaType()).consistentWith(this.buildQueryScanConsistency()).matching(query).all();
    }

    private QueryScanConsistency buildQueryScanConsistency() {
        QueryScanConsistency scanConsistency = QueryScanConsistency.NOT_BOUNDED;
        if (this.crudMethodMetadata.getScanConsistency() != null) {
            scanConsistency = this.crudMethodMetadata.getScanConsistency().query();
        }
        return scanConsistency;
    }

    void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.crudMethodMetadata = crudMethodMetadata;
    }
}

