/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByIdOperation;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperationSupport;
import org.springframework.util.Assert;

public class ExecutableFindByIdOperationSupport
implements ExecutableFindByIdOperation {
    private final CouchbaseTemplate template;

    ExecutableFindByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByIdOperation.ExecutableFindById<T> findById(Class<T> domainType) {
        return new ExecutableFindByIdSupport<T>(this.template, domainType, null, null);
    }

    static class ExecutableFindByIdSupport<T>
    implements ExecutableFindByIdOperation.ExecutableFindById<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final List<String> fields;
        private final ReactiveFindByIdOperationSupport.ReactiveFindByIdSupport<T> reactiveSupport;

        ExecutableFindByIdSupport(CouchbaseTemplate template, Class<T> domainType, String collection, List<String> fields) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.fields = fields;
            this.reactiveSupport = new ReactiveFindByIdOperationSupport.ReactiveFindByIdSupport<T>(template.reactive(), domainType, collection, fields);
        }

        @Override
        public T one(String id) {
            return (T)this.reactiveSupport.one(id).block();
        }

        @Override
        public Collection<? extends T> all(Collection<String> ids) {
            return (Collection)this.reactiveSupport.all(ids).collectList().block();
        }

        @Override
        public ExecutableFindByIdOperation.TerminatingFindById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, collection, this.fields);
        }

        @Override
        public ExecutableFindByIdOperation.FindByIdWithCollection<T> project(String ... fields) {
            Assert.notEmpty((Object[])fields, (String)"Fields must not be null nor empty.");
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, this.collection, Arrays.asList(fields));
        }
    }
}

