/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.time.Duration;
import java.util.Collection;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveInsertByIdOperation;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveInsertByIdOperationSupport
implements ReactiveInsertByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    public ReactiveInsertByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveInsertByIdOperation.ReactiveInsertById<T> insertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveInsertByIdSupport<T>(this.template, domainType, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, Duration.ofSeconds(0L));
    }

    static class ReactiveInsertByIdSupport<T>
    implements ReactiveInsertByIdOperation.ReactiveInsertById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;

        ReactiveInsertByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String collection, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
        }

        @Override
        public Mono<T> one(T object) {
            return Mono.just(object).flatMap(o -> {
                CouchbaseDocument converted = this.template.support().encodeEntity(o);
                return this.template.getCollection(this.collection).reactive().insert(converted.getId(), converted.export(), this.buildInsertOptions()).map(result -> {
                    Object updatedObject = this.template.support().applyUpdatedId(o, converted.getId());
                    return this.template.support().applyUpdatedCas(updatedObject, result.cas());
                });
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        private InsertOptions buildInsertOptions() {
            InsertOptions options = InsertOptions.insertOptions();
            if (this.persistTo != PersistTo.NONE || this.replicateTo != ReplicateTo.NONE) {
                options.durability(this.persistTo, this.replicateTo);
            } else if (this.durabilityLevel != DurabilityLevel.NONE) {
                options.durability(this.durabilityLevel);
            }
            if (this.expiry != null && !this.expiry.isZero()) {
                options.expiry(this.expiry);
            } else if (this.domainType.isAnnotationPresent(Document.class)) {
                Document documentAnn = this.domainType.getAnnotation(Document.class);
                long durationSeconds = documentAnn.expiryUnit().toSeconds(documentAnn.expiry());
                options.expiry(Duration.ofSeconds(durationSeconds));
            }
            return options;
        }

        @Override
        public ReactiveInsertByIdOperation.TerminatingInsertById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, collection, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithCollection<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.collection, this.persistTo, this.replicateTo, durabilityLevel, this.expiry);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithCollection<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.collection, persistTo, replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.collection, this.persistTo, this.replicateTo, this.durabilityLevel, expiry);
        }
    }
}

