/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.query.QueryScanConsistency;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.StringN1qlQueryCreator;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.PartTree;

public class ReactiveN1qlRepositoryQueryExecutor {
    private final ReactiveCouchbaseOperations operations;
    private final CouchbaseQueryMethod queryMethod;
    private final NamedQueries namedQueries;

    public ReactiveN1qlRepositoryQueryExecutor(ReactiveCouchbaseOperations operations, CouchbaseQueryMethod queryMethod, NamedQueries namedQueries) {
        this.operations = operations;
        this.queryMethod = queryMethod;
        this.namedQueries = namedQueries;
    }

    public Object execute(Object[] parameters) {
        Query query;
        Class domainClass = this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        String namedQueryName = this.queryMethod.getNamedQueryName();
        if (this.queryMethod.hasN1qlAnnotation()) {
            query = (Query)new StringN1qlQueryCreator((ParameterAccessor)accessor, this.queryMethod, this.operations.getConverter(), this.operations.getBucketName(), QueryMethodEvaluationContextProvider.DEFAULT, this.namedQueries).createQuery();
        } else {
            PartTree tree = new PartTree(this.queryMethod.getName(), domainClass);
            query = (Query)new N1qlQueryCreator(tree, (ParameterAccessor)accessor, this.queryMethod, this.operations.getConverter()).createQuery();
        }
        ReactiveFindByQueryOperation.ReactiveFindByQuery q = (ReactiveFindByQueryOperation.ReactiveFindByQuery)this.operations.findByQuery(domainClass).consistentWith(this.buildQueryScanConsistency()).matching(query);
        if (this.queryMethod.isCountQuery()) {
            return q.count();
        }
        if (this.queryMethod.isCollectionQuery()) {
            return q.all();
        }
        return q.one();
    }

    private QueryScanConsistency buildQueryScanConsistency() {
        QueryScanConsistency scanConsistency = QueryScanConsistency.NOT_BOUNDED;
        if (this.queryMethod.hasConsistencyAnnotation()) {
            scanConsistency = this.queryMethod.getConsistencyAnnotation().value();
        } else if (this.queryMethod.hasScanConsistencyAnnotation()) {
            scanConsistency = this.queryMethod.getScanConsistencyAnnotation().query();
        }
        return scanConsistency;
    }
}

