/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringBasedN1qlQueryParser {
    public static final String SPEL_PREFIX = "n1ql";
    public static final String SPEL_SELECT_FROM_CLAUSE = "#n1ql.selectEntity";
    public static final String SPEL_BUCKET = "#n1ql.bucket";
    public static final String SPEL_ENTITY = "#n1ql.fields";
    public static final String SPEL_FILTER = "#n1ql.filter";
    public static final String SPEL_DELETE = "#n1ql.delete";
    public static final String SPEL_RETURNING = "#n1ql.returning";
    public static final Pattern NAMED_PLACEHOLDER_PATTERN = Pattern.compile("\\W(\\$\\p{Alpha}\\p{Alnum}*)\\b");
    public static final Pattern POSITIONAL_PLACEHOLDER_PATTERN = Pattern.compile("\\W(\\$\\p{Digit}+)\\b");
    public static final Pattern QUOTE_DETECTION_PATTERN = Pattern.compile("[\"'](?:[^\"'\\\\]*(?:\\\\.)?)*[\"']");
    private static final Logger LOGGER = LoggerFactory.getLogger(StringBasedN1qlQueryParser.class);
    private final String statement;
    private final QueryMethod queryMethod;
    private PlaceholderType placeHolderType;
    private final N1qlSpelValues statementContext;
    private final N1qlSpelValues countContext;
    private final CouchbaseConverter couchbaseConverter;
    private final Collection<String> parameterNames = new HashSet<String>();
    public final N1QLExpression parsedExpression;

    public StringBasedN1qlQueryParser(String statement, QueryMethod queryMethod, String bucketName, CouchbaseConverter couchbaseConverter, String typeField, String typeValue, ParameterAccessor accessor, SpelExpressionParser parser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.statement = statement;
        this.queryMethod = queryMethod;
        this.statementContext = StringBasedN1qlQueryParser.createN1qlSpelValues(bucketName, typeField, typeValue, false);
        this.countContext = StringBasedN1qlQueryParser.createN1qlSpelValues(bucketName, typeField, typeValue, true);
        this.couchbaseConverter = couchbaseConverter;
        this.parsedExpression = this.getExpression(accessor, StringBasedN1qlQueryParser.getParameters(accessor), null, parser, evaluationContextProvider);
        this.checkPlaceholders(this.parsedExpression.toString());
    }

    public static N1qlSpelValues createN1qlSpelValues(String bucketName, String typeField, String typeValue, boolean isCount) {
        String b = "`" + bucketName + "`";
        String entity = "META(" + b + ").id AS " + "__id" + ", META(" + b + ").cas AS " + "__cas";
        String count = "COUNT(*) AS count";
        String selectEntity = isCount ? "SELECT " + count + " FROM " + b : "SELECT " + entity + ", " + b + ".* FROM " + b;
        String typeSelection = "`" + typeField + "` = \"" + typeValue + "\"";
        String delete = N1QLExpression.delete().from(N1QLExpression.i(bucketName)).toString();
        String returning = " returning " + N1qlUtils.createReturningExpressionForDelete(bucketName).toString();
        return new N1qlSpelValues(selectEntity, entity, b, typeSelection, delete, returning);
    }

    public String doParse(SpelExpressionParser parser, EvaluationContext evaluationContext, boolean isCountQuery) {
        Expression parsedExpression = parser.parseExpression(this.getStatement(), (ParserContext)new TemplateParserContext());
        if (isCountQuery) {
            evaluationContext.setVariable(SPEL_PREFIX, (Object)this.getCountContext());
        } else {
            evaluationContext.setVariable(SPEL_PREFIX, (Object)this.getStatementContext());
        }
        return (String)parsedExpression.getValue(evaluationContext, String.class);
    }

    private void checkPlaceholders(String statement) {
        String placeholder;
        Matcher quoteMatcher = QUOTE_DETECTION_PATTERN.matcher(statement);
        Matcher positionMatcher = POSITIONAL_PLACEHOLDER_PATTERN.matcher(statement);
        Matcher namedMatcher = NAMED_PLACEHOLDER_PATTERN.matcher(statement);
        ArrayList<int[]> quotes = new ArrayList<int[]>();
        while (quoteMatcher.find()) {
            quotes.add(new int[]{quoteMatcher.start(), quoteMatcher.end()});
        }
        int posCount = 0;
        int namedCount = 0;
        while (positionMatcher.find()) {
            placeholder = positionMatcher.group(1);
            if (!this.checkNotQuoted(placeholder, positionMatcher.start(), positionMatcher.end(), quotes)) continue;
            LOGGER.trace("{}: Found positional placeholder {}", (Object)this.queryMethod.getName(), (Object)placeholder);
            ++posCount;
            this.parameterNames.add(placeholder.substring(1));
        }
        while (namedMatcher.find()) {
            placeholder = namedMatcher.group(1);
            if (!this.checkNotQuoted(placeholder, namedMatcher.start(), namedMatcher.end(), quotes)) continue;
            LOGGER.trace("{}: Found named placeholder {}", (Object)this.queryMethod.getName(), (Object)placeholder);
            ++namedCount;
            this.parameterNames.add(placeholder.substring(1));
        }
        if (posCount > 0 && namedCount > 0) {
            throw new IllegalArgumentException("Using both named (" + namedCount + ") and positional (" + posCount + ") placeholders is not supported, please choose one over the other in " + this.queryMethod.getClass().getName() + "." + this.queryMethod.getName() + "()");
        }
        this.placeHolderType = posCount > 0 ? PlaceholderType.POSITIONAL : (namedCount > 0 ? PlaceholderType.NAMED : PlaceholderType.NONE);
    }

    private boolean checkNotQuoted(String item, int start, int end, List<int[]> quotes) {
        for (int[] quote : quotes) {
            if (quote[0] > start || quote[1] < end) continue;
            LOGGER.trace("{}: potential placeholder {} is inside quotes, ignored", (Object)this.queryMethod.getName(), (Object)item);
            return false;
        }
        return true;
    }

    private JsonValue getPositionalPlaceholderValues(ParameterAccessor accessor) {
        JsonArray posValues = JsonArray.create();
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            Object rawValue = accessor.getBindableValue(parameter.getIndex());
            Object value = this.couchbaseConverter.convertForWriteIfNeeded(rawValue);
            this.putPositionalValue(posValues, value);
        }
        return posValues;
    }

    private JsonObject getNamedPlaceholderValues(ParameterAccessor accessor) {
        JsonObject namedValues = JsonObject.create();
        HashSet<String> pNames = new HashSet<String>(this.parameterNames);
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            String placeholder = parameter.getPlaceholder();
            Object rawValue = accessor.getBindableValue(parameter.getIndex());
            Object value = this.couchbaseConverter.convertForWriteIfNeeded(rawValue);
            if (placeholder != null && placeholder.charAt(0) == ':') {
                placeholder = placeholder.replaceFirst(":", "");
                this.putNamedValue(namedValues, placeholder, value);
                if (pNames.contains(placeholder)) {
                    pNames.remove(placeholder);
                    continue;
                }
                throw new RuntimeException("parameter named " + placeholder + " does not match any named parameter " + this.parameterNames + " in " + this.statement);
            }
            if (parameter.getName().isPresent()) {
                this.putNamedValue(namedValues, (String)parameter.getName().get(), value);
                continue;
            }
            throw new RuntimeException("cannot determine argument for named parameter. Argument " + parameter.getIndex() + " to " + this.queryMethod.getClass().getName() + "." + this.queryMethod.getName() + "() needs @Param(\"name\") that matches a named parameter in " + this.statement);
        }
        if (!pNames.isEmpty()) {
            throw new RuntimeException("no parameter found for " + pNames);
        }
        return namedValues;
    }

    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        switch (this.placeHolderType) {
            case NAMED: {
                return this.getNamedPlaceholderValues(accessor);
            }
            case POSITIONAL: {
                return this.getPositionalPlaceholderValues(accessor);
            }
        }
        return JsonArray.create();
    }

    private void putPositionalValue(JsonArray posValues, Object value) {
        try {
            posValues.add(value);
        }
        catch (InvalidArgumentException iae) {
            if (value instanceof Object[]) {
                this.addAsArray(posValues, value);
            }
            throw iae;
        }
    }

    private void addAsArray(JsonArray posValues, Object o) {
        Object[] array = (Object[])o;
        JsonArray ja = JsonValue.ja();
        for (Object e : array) {
            ja.add(String.valueOf(this.couchbaseConverter.convertForWriteIfNeeded(e)));
        }
        posValues.add(ja);
    }

    private void putNamedValue(JsonObject namedValues, String placeholder, Object value) {
        try {
            namedValues.put(placeholder, value);
        }
        catch (InvalidArgumentException iae) {
            if (value instanceof Object[]) {
                this.addAsArray(namedValues, placeholder, value);
            }
            throw iae;
        }
    }

    private void addAsArray(JsonObject namedValues, String placeholder, Object o) {
        Object[] array = (Object[])o;
        JsonArray ja = JsonValue.ja();
        for (Object e : array) {
            ja.add(String.valueOf(this.couchbaseConverter.convertForWriteIfNeeded(e)));
        }
        namedValues.put(placeholder, ja);
    }

    protected boolean useGeneratedCountQuery() {
        return this.statement.contains(SPEL_SELECT_FROM_CLAUSE);
    }

    public N1qlSpelValues getCountContext() {
        return this.countContext;
    }

    public N1qlSpelValues getStatementContext() {
        return this.statementContext;
    }

    public String getStatement() {
        return this.statement;
    }

    private N1QLExpression getExpression(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType, SpelExpressionParser parser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Pageable pageable;
        boolean isCountQuery = this.queryMethod.getName().toLowerCase().startsWith("count");
        EvaluationContext evaluationContext = evaluationContextProvider.getEvaluationContext(this.queryMethod.getParameters(), runtimeParameters);
        N1QLExpression parsedStatement = N1QLExpression.x(this.doParse(parser, evaluationContext, isCountQuery));
        Sort sort = accessor.getSort();
        if (sort.isSorted()) {
            N1QLExpression[] cbSorts = N1qlUtils.createSort(sort);
            parsedStatement = parsedStatement.orderBy(cbSorts);
        }
        if (this.queryMethod.isPageQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            parsedStatement = parsedStatement.limit(pageable.getPageSize()).offset(Math.toIntExact(pageable.getOffset()));
        } else if (this.queryMethod.isSliceQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            parsedStatement = parsedStatement.limit(pageable.getPageSize() + 1).offset(Math.toIntExact(pageable.getOffset()));
        }
        return parsedStatement;
    }

    private static Object[] getParameters(ParameterAccessor accessor) {
        ArrayList params = new ArrayList();
        for (Object o : accessor) {
            params.add(o);
        }
        return params.toArray();
    }

    public static final class N1qlSpelValues {
        public final String selectEntity;
        public final String fields;
        public final String bucket;
        public final String filter;
        public final String delete;
        public final String returning;

        public N1qlSpelValues(String selectClause, String entityFields, String bucket, String filter, String delete, String returning) {
            this.selectEntity = selectClause;
            this.fields = entityFields;
            this.bucket = bucket;
            this.filter = filter;
            this.delete = delete;
            this.returning = returning;
        }
    }

    private static enum PlaceholderType {
        NAMED,
        POSITIONAL,
        NONE;

    }
}

