/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadata;
import org.springframework.data.couchbase.repository.support.Util;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class SimpleCouchbaseRepository<T, ID>
implements CouchbaseRepository<T, ID> {
    private final CouchbaseOperations couchbaseOperations;
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private CrudMethodMetadata crudMethodMetadata;

    public SimpleCouchbaseRepository(CouchbaseEntityInformation<T, String> entityInformation, CouchbaseOperations couchbaseOperations) {
        Assert.notNull(entityInformation, (String)"CouchbaseEntityInformation must not be null!");
        Assert.notNull((Object)couchbaseOperations, (String)"CouchbaseOperations must not be null!");
        this.entityInformation = entityInformation;
        this.couchbaseOperations = couchbaseOperations;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (Util.hasNonZeroVersionProperty(entity, this.couchbaseOperations.getConverter())) {
            return this.couchbaseOperations.replaceById(this.entityInformation.getJavaType()).one(entity);
        }
        return this.couchbaseOperations.upsertById(this.entityInformation.getJavaType()).one(entity);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return (Iterable)Streamable.of(entities).stream().map(e -> this.save(e)).collect(StreamUtils.toUnmodifiableList());
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return Optional.ofNullable(this.couchbaseOperations.findById(this.entityInformation.getJavaType()).one(id.toString()));
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        List<String> convertedIds = Streamable.of(ids).stream().map(Objects::toString).collect(Collectors.toList());
        Collection all = this.couchbaseOperations.findById(this.entityInformation.getJavaType()).all(convertedIds);
        return (List)Streamable.of(all).stream().collect(StreamUtils.toUnmodifiableList());
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.couchbaseOperations.existsById().one(id.toString());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.couchbaseOperations.removeById().one(id.toString());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.couchbaseOperations.removeById().one((String)this.entityInformation.getId(entity));
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        this.couchbaseOperations.removeById().all(Streamable.of(entities).map(arg_0 -> this.entityInformation.getId(arg_0)).toList());
    }

    public long count() {
        return this.couchbaseOperations.findByQuery(this.entityInformation.getJavaType()).consistentWith(this.buildQueryScanConsistency()).count();
    }

    public void deleteAll() {
        this.couchbaseOperations.removeByQuery(this.entityInformation.getJavaType()).consistentWith(this.buildQueryScanConsistency()).all();
    }

    @Override
    public List<T> findAll() {
        return this.findAll(new Query());
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    @Override
    public List<T> findAll(QueryScanConsistency queryScanConsistency) {
        return this.findAll(new Query().scanConsistency(queryScanConsistency));
    }

    public Page<T> findAll(Pageable pageable) {
        List<T> results = this.findAll(new Query().with(pageable));
        return new PageImpl(results, pageable, this.count());
    }

    protected CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    private List<T> findAll(Query query) {
        return this.couchbaseOperations.findByQuery(this.entityInformation.getJavaType()).consistentWith(this.buildQueryScanConsistency()).matching(query).all();
    }

    private QueryScanConsistency buildQueryScanConsistency() {
        QueryScanConsistency scanConsistency = QueryScanConsistency.NOT_BOUNDED;
        if (this.crudMethodMetadata.getScanConsistency() != null) {
            scanConsistency = this.crudMethodMetadata.getScanConsistency().query();
        }
        return scanConsistency;
    }

    void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.crudMethodMetadata = crudMethodMetadata;
    }
}

