/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.event.AfterConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

class CouchbaseTemplateSupport
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseTemplateSupport.class);
    private final CouchbaseConverter converter;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final TranslationService translationService;
    private EntityCallbacks entityCallbacks;
    private ApplicationContext applicationContext;

    public CouchbaseTemplateSupport(CouchbaseConverter converter, TranslationService translationService) {
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.translationService = translationService;
    }

    public CouchbaseDocument encodeEntity(Object entityToEncode) {
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(entityToEncode));
        Object maybeNewEntity = this.maybeCallBeforeConvert(entityToEncode, "");
        CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(maybeNewEntity, converted);
        this.maybeCallAfterConvert(entityToEncode, converted, "");
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(entityToEncode, converted));
        return converted;
    }

    public <T> T decodeEntity(String id, String source, long cas, Class<T> entityClass) {
        CouchbaseDocument converted = new CouchbaseDocument(id);
        converted.setId(id);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        if (cas != 0L && persistentEntity.getVersionProperty() != null) {
            converted.put(((CouchbasePersistentProperty)persistentEntity.getVersionProperty()).getName(), cas);
        }
        Object readEntity = this.converter.read(entityClass, (CouchbaseDocument)this.translationService.decode(source, converted));
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(readEntity);
        if (persistentEntity.getVersionProperty() != null) {
            accessor.setProperty(persistentEntity.getVersionProperty(), (Object)cas);
        }
        return (T)accessor.getBean();
    }

    public Object applyUpdatedCas(Object entity, long cas) {
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        if (versionProperty != null) {
            accessor.setProperty((PersistentProperty)versionProperty, (Object)cas);
            return accessor.getBean();
        }
        return entity;
    }

    public Object applyUpdatedId(Object entity, Object id) {
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null) {
            accessor.setProperty((PersistentProperty)idProperty, id);
            return accessor.getBean();
        }
        return entity;
    }

    public long getCas(Object entity) {
        Number casObject;
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        long cas = 0L;
        if (versionProperty != null && (casObject = (Number)accessor.getProperty((PersistentProperty)versionProperty)) instanceof Number) {
            cas = casObject.longValue();
        }
        return cas;
    }

    public String getJavaNameForEntity(Class<?> clazz) {
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
        MappingCouchbaseEntityInformation info = new MappingCouchbaseEntityInformation(persistentEntity);
        return info.getJavaType().getName();
    }

    private <T> ConvertingPropertyAccessor<T> getPropertyAccessor(T source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    void maybeEmitEvent(CouchbaseMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            try {
                this.applicationContext.publishEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LOG.info("maybeEmitEvent called, but CouchbaseTemplate not initialized with applicationContext");
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    protected <T> T maybeCallBeforeConvert(T object, String collection) {
        if (this.entityCallbacks != null) {
            try {
                return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{collection});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LOG.info("maybeCallBeforeConvert called, but CouchbaseTemplate not initialized with applicationContext");
        }
        return object;
    }

    protected <T> T maybeCallAfterConvert(T object, CouchbaseDocument document, String collection) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{document, collection});
        }
        LOG.info("maybeCallAfterConvert called, but CouchbaseTemplate not initialized with applicationContext");
        return object;
    }
}

