/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import java.util.Optional;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRemoveByQueryOperationSupport
implements ReactiveRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;

    public ReactiveRemoveByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ReactiveRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED, null);
    }

    static class ReactiveRemoveByQuerySupport<T>
    implements ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;
        private final String collection;

        ReactiveRemoveByQuerySupport(ReactiveCouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency, String collection) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.scanConsistency = scanConsistency;
            this.collection = collection;
        }

        @Override
        public Flux<RemoveResult> all() {
            return Flux.defer(() -> {
                String statement = this.assembleDeleteQuery();
                Mono allResult = this.collection == null ? this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.buildQueryOptions()) : this.template.getCouchbaseClientFactory().getScope().reactive().query(statement, this.buildQueryOptions());
                return allResult.onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> new RemoveResult(row.getString("__id"), row.getLong("__cas"), Optional.empty()));
            });
        }

        private QueryOptions buildQueryOptions() {
            QueryOptions options = QueryOptions.queryOptions();
            if (this.scanConsistency != null) {
                options.scanConsistency(this.scanConsistency);
            }
            return options;
        }

        @Override
        public ReactiveRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency, this.collection);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryWithConsistency<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, collection);
        }

        @Override
        @Deprecated
        public ReactiveRemoveByQueryOperation.RemoveByQueryInCollection<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.collection);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.collection);
        }

        private String assembleDeleteQuery() {
            return this.query.toN1qlRemoveString(this.template, this.collection, this.domainType);
        }
    }
}

