/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import java.time.Duration;
import java.util.Collection;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveReplaceByIdOperation;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveReplaceByIdOperationSupport
implements ReactiveReplaceByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    public ReactiveReplaceByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveReplaceByIdOperation.ReactiveReplaceById<T> replaceById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveReplaceByIdSupport<T>(this.template, domainType, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null);
    }

    static class ReactiveReplaceByIdSupport<T>
    implements ReactiveReplaceByIdOperation.ReactiveReplaceById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;

        ReactiveReplaceByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String collection, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
        }

        @Override
        public Mono<T> one(T object) {
            return Mono.just(object).flatMap(o -> {
                CouchbaseDocument converted = this.template.support().encodeEntity(o);
                return this.template.getCollection(this.collection).reactive().replace(converted.getId(), converted.export(), this.buildReplaceOptions(o, converted)).map(result -> this.template.support().applyUpdatedCas(o, result.cas()));
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        private ReplaceOptions buildReplaceOptions(T object, CouchbaseDocument doc) {
            ReplaceOptions options = ReplaceOptions.replaceOptions();
            if (this.persistTo != PersistTo.NONE || this.replicateTo != ReplicateTo.NONE) {
                options.durability(this.persistTo, this.replicateTo);
            } else if (this.durabilityLevel != DurabilityLevel.NONE) {
                options.durability(this.durabilityLevel);
            }
            if (this.expiry != null) {
                options.expiry(this.expiry);
            } else if (doc.getExpiration() != 0) {
                options.expiry(Duration.ofSeconds(doc.getExpiration()));
            }
            long cas = this.template.support().getCas(object);
            options.cas(cas);
            return options;
        }

        @Override
        public ReactiveReplaceByIdOperation.TerminatingReplaceById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, collection, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdWithCollection<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.collection, this.persistTo, this.replicateTo, durabilityLevel, this.expiry);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdWithCollection<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.collection, persistTo, replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.collection, this.persistTo, this.replicateTo, this.durabilityLevel, expiry);
        }
    }
}

