/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsScanConsistency;
import com.couchbase.client.java.analytics.ReactiveAnalyticsResult;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.query.AnalyticsQuery;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByAnalyticsOperationSupport
implements ReactiveFindByAnalyticsOperation {
    private static final AnalyticsQuery ALL_QUERY = new AnalyticsQuery();
    private final ReactiveCouchbaseTemplate template;

    public ReactiveFindByAnalyticsOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByAnalyticsOperation.ReactiveFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ReactiveFindByAnalyticsSupport<T>(this.template, domainType, ALL_QUERY, AnalyticsScanConsistency.NOT_BOUNDED);
    }

    static class ReactiveFindByAnalyticsSupport<T>
    implements ReactiveFindByAnalyticsOperation.ReactiveFindByAnalytics<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final AnalyticsQuery query;
        private final AnalyticsScanConsistency scanConsistency;

        ReactiveFindByAnalyticsSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, AnalyticsQuery query, AnalyticsScanConsistency scanConsistency) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.scanConsistency = scanConsistency;
        }

        @Override
        public ReactiveFindByAnalyticsOperation.TerminatingFindByAnalytics<T> matching(AnalyticsQuery query) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, query, this.scanConsistency);
        }

        @Override
        @Deprecated
        public ReactiveFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> consistentWith(AnalyticsScanConsistency scanConsistency) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }

        @Override
        public ReactiveFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> withConsistency(AnalyticsScanConsistency scanConsistency) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }

        @Override
        public Mono<T> one() {
            return this.all().singleOrEmpty();
        }

        @Override
        public Mono<T> first() {
            return this.all().next();
        }

        @Override
        public Flux<T> all() {
            return Flux.defer(() -> {
                String statement = this.assembleEntityQuery(false);
                return this.template.getCouchbaseClientFactory().getCluster().reactive().analyticsQuery(statement, this.buildAnalyticsOptions()).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveAnalyticsResult::rowsAsObject).map(row -> {
                    String id = row.getString("__id");
                    long cas = row.getLong("__cas");
                    row.removeKey("__id");
                    row.removeKey("__cas");
                    return this.template.support().decodeEntity(id, row.toString(), cas, this.domainType);
                });
            });
        }

        @Override
        public Mono<Long> count() {
            return Mono.defer(() -> {
                String statement = this.assembleEntityQuery(true);
                return this.template.getCouchbaseClientFactory().getCluster().reactive().analyticsQuery(statement, this.buildAnalyticsOptions()).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveAnalyticsResult::rowsAsObject).map(row -> row.getLong("__count")).next();
            });
        }

        @Override
        public Mono<Boolean> exists() {
            return this.count().map(count -> count > 0L);
        }

        private String assembleEntityQuery(boolean count) {
            String bucket = "`" + this.template.getBucketName() + "`";
            StringBuilder statement = new StringBuilder("SELECT ");
            if (count) {
                statement.append("count(*) as __count");
            } else {
                statement.append("meta().id as __id, meta().cas as __cas, ").append(bucket).append(".*");
            }
            String dataset = this.template.support().getJavaNameForEntity(this.domainType);
            statement.append(" FROM ").append(dataset);
            this.query.appendSort(statement);
            this.query.appendSkipAndLimit(statement);
            return statement.toString();
        }

        private AnalyticsOptions buildAnalyticsOptions() {
            AnalyticsOptions options = AnalyticsOptions.analyticsOptions();
            if (this.scanConsistency != null) {
                options.scanConsistency(this.scanConsistency);
            }
            return options;
        }
    }
}

