/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class PartTreeCouchbaseQuery
extends AbstractCouchbaseQuery {
    private final PartTree tree;
    private final CouchbaseConverter converter;

    public PartTreeCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations, expressionParser, evaluationContextProvider);
        ResultProcessor processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), processor.getReturnedType().getDomainType());
        this.converter = operations.getConverter();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Query createQuery(ParametersParameterAccessor accessor) {
        N1qlQueryCreator creator = new N1qlQueryCreator(this.tree, (ParameterAccessor)accessor, this.getQueryMethod(), this.converter, ((CouchbaseOperations)this.getOperations()).getBucketName());
        Query query = (Query)creator.createQuery();
        if (this.tree.isLimiting()) {
            query.limit(this.tree.getMaxResults());
        }
        return query;
    }

    @Override
    protected Query createCountQuery(ParametersParameterAccessor accessor) {
        return (Query)new N1qlQueryCreator(this.tree, (ParameterAccessor)accessor, this.getQueryMethod(), this.converter, ((CouchbaseOperations)this.getOperations()).getBucketName()).createQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isLimiting() {
        return this.tree.isLimiting();
    }
}

