/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import java.util.Collection;
import java.util.Map;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableExistsByIdOperation;
import org.springframework.data.couchbase.core.ReactiveExistsByIdOperationSupport;
import org.springframework.util.Assert;

public class ExecutableExistsByIdOperationSupport
implements ExecutableExistsByIdOperation {
    private final CouchbaseTemplate template;

    ExecutableExistsByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ExecutableExistsByIdOperation.ExecutableExistsById existsById() {
        return new ExecutableExistsByIdSupport(this.template, null);
    }

    static class ExecutableExistsByIdSupport
    implements ExecutableExistsByIdOperation.ExecutableExistsById {
        private final CouchbaseTemplate template;
        private final ReactiveExistsByIdOperationSupport.ReactiveExistsByIdSupport reactiveSupport;

        ExecutableExistsByIdSupport(CouchbaseTemplate template, String collection) {
            this.template = template;
            this.reactiveSupport = new ReactiveExistsByIdOperationSupport.ReactiveExistsByIdSupport(template.reactive(), collection);
        }

        @Override
        public boolean one(String id) {
            return (Boolean)this.reactiveSupport.one(id).block();
        }

        @Override
        public Map<String, Boolean> all(Collection<String> ids) {
            return (Map)this.reactiveSupport.all(ids).block();
        }

        @Override
        public ExecutableExistsByIdOperation.TerminatingExistsById inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableExistsByIdSupport(this.template, collection);
        }
    }
}

