/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperationSupport;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.util.Assert;

public class ExecutableFindByQueryOperationSupport
implements ExecutableFindByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final CouchbaseTemplate template;

    public ExecutableFindByQueryOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByQueryOperation.ExecutableFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ExecutableFindByQuerySupport<T>(this.template, domainType, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED, null, null);
    }

    static class ExecutableFindByQuerySupport<T>
    implements ExecutableFindByQueryOperation.ExecutableFindByQuery<T> {
        private final CouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        private final ReactiveFindByQueryOperationSupport.ReactiveFindByQuerySupport<T> reactiveSupport;
        private final QueryScanConsistency scanConsistency;
        private final String collection;
        private final String[] distinctFields;

        ExecutableFindByQuerySupport(CouchbaseTemplate template, Class<?> domainType, Class<T> returnType, Query query, QueryScanConsistency scanConsistency, String collection, String[] distinctFields) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.reactiveSupport = new ReactiveFindByQueryOperationSupport.ReactiveFindByQuerySupport<T>(template.reactive(), domainType, returnType, query, scanConsistency, collection, distinctFields);
            this.scanConsistency = scanConsistency;
            this.collection = collection;
            this.distinctFields = distinctFields;
        }

        @Override
        public T oneValue() {
            return (T)this.reactiveSupport.one().block();
        }

        @Override
        public T firstValue() {
            return (T)this.reactiveSupport.first().block();
        }

        @Override
        public List<T> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableFindByQueryOperation.TerminatingFindByQuery<T> matching(Query query) {
            QueryScanConsistency scanCons = query.getScanConsistency() != null ? query.getScanConsistency() : this.scanConsistency;
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, query, scanCons, this.collection, this.distinctFields);
        }

        @Override
        @Deprecated
        public ExecutableFindByQueryOperation.FindByQueryInCollection<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.collection, this.distinctFields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.collection, this.distinctFields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryWithConsistency<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, collection, this.distinctFields);
        }

        @Override
        public <R> ExecutableFindByQueryOperation.FindByQueryWithConsistency<R> as(Class<R> resturnType) {
            Assert.notNull(resturnType, (String)"returnType must not be null!");
            return new ExecutableFindByQuerySupport<R>(this.template, this.domainType, resturnType, this.query, this.scanConsistency, this.collection, this.distinctFields);
        }

        @Override
        public ExecutableFindByQueryOperation.FindByQueryWithProjection<T> distinct(String[] distinctFields) {
            Assert.notNull((Object)distinctFields, (String)"distinctFields must not be null!");
            return new ExecutableFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.collection, distinctFields);
        }

        @Override
        public Stream<T> stream() {
            return this.reactiveSupport.all().toStream();
        }

        @Override
        public long count() {
            return (Long)this.reactiveSupport.count().block();
        }

        @Override
        public boolean exists() {
            return this.count() > 0L;
        }
    }
}

