/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperation;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByIdOperationSupport
implements ReactiveFindByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    ReactiveFindByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByIdOperation.ReactiveFindById<T> findById(Class<T> domainType) {
        return new ReactiveFindByIdSupport<T>(this.template, domainType, null, null);
    }

    static class ReactiveFindByIdSupport<T>
    implements ReactiveFindByIdOperation.ReactiveFindById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final List<String> fields;

        ReactiveFindByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String collection, List<String> fields) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.fields = fields;
        }

        @Override
        public Mono<T> one(String id) {
            return Mono.just((Object)id).flatMap(docId -> {
                GetOptions options = GetOptions.getOptions().transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
                if (this.fields != null && !this.fields.isEmpty()) {
                    options.project(this.fields);
                }
                return this.template.getCollection(this.collection).reactive().get(docId, options);
            }).map(result -> this.template.support().decodeEntity(id, (String)result.contentAs(String.class), result.cas(), this.domainType)).onErrorResume(throwable -> {
                if (throwable instanceof RuntimeException && throwable instanceof DocumentNotFoundException) {
                    return Mono.empty();
                }
                return Mono.error((Throwable)throwable);
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::one);
        }

        @Override
        public ReactiveFindByIdOperation.TerminatingFindById<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, collection, this.fields);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdWithCollection<T> project(String ... fields) {
            Assert.notEmpty((Object[])fields, (String)"Fields must not be null nor empty.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.collection, Arrays.asList(fields));
        }
    }
}

