/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.index;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.index.CompositeQueryIndex;
import org.springframework.data.couchbase.core.index.CompositeQueryIndexes;
import org.springframework.data.couchbase.core.index.IndexDefinition;
import org.springframework.data.couchbase.core.index.QueryIndexDirection;
import org.springframework.data.couchbase.core.index.QueryIndexResolver;
import org.springframework.data.couchbase.core.index.QueryIndexed;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CouchbasePersistentEntityIndexResolver
implements QueryIndexResolver {
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final CouchbaseOperations operations;

    public CouchbasePersistentEntityIndexResolver(MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext, CouchbaseOperations operations) {
        this.mappingContext = mappingContext;
        this.operations = operations;
    }

    public Iterable<? extends IndexDefinitionHolder> resolveIndexFor(TypeInformation<?> typeInformation) {
        return this.resolveIndexForEntity((CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeInformation));
    }

    public List<IndexDefinitionHolder> resolveIndexForEntity(CouchbasePersistentEntity<?> root) {
        Assert.notNull(root, (String)"CouchbasePersistentEntity must not be null!");
        Document document = (Document)root.findAnnotation(Document.class);
        Assert.notNull((Object)document, () -> String.format("Entity %s is not a collection root. Make sure to annotate it with @Document!", root.getName()));
        ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        root.doWithProperties(property -> this.potentiallyAddIndexForProperty(root, (CouchbasePersistentProperty)property, (List<IndexDefinitionHolder>)indexInformation));
        return indexInformation;
    }

    private void potentiallyAddIndexForProperty(CouchbasePersistentEntity<?> root, CouchbasePersistentProperty persistentProperty, List<IndexDefinitionHolder> indexes) {
        List<IndexDefinitionHolder> indexDefinitions = this.createIndexDefinitionHolderForProperty(persistentProperty.getFieldName(), root, persistentProperty);
        if (!indexDefinitions.isEmpty()) {
            indexes.addAll(indexDefinitions);
        }
    }

    private List<IndexDefinitionHolder> createIndexDefinitionHolderForProperty(String dotPath, CouchbasePersistentEntity<?> persistentEntity, CouchbasePersistentProperty persistentProperty) {
        ArrayList<IndexDefinitionHolder> indices = new ArrayList<IndexDefinitionHolder>();
        if (persistentProperty.isAnnotationPresent(QueryIndexed.class)) {
            indices.add(this.createFieldQueryIndexDefinition(persistentEntity, persistentProperty));
        }
        if (persistentEntity.isAnnotationPresent(CompositeQueryIndex.class) || persistentEntity.isAnnotationPresent(CompositeQueryIndexes.class)) {
            indices.addAll(this.createCompositeQueryIndexDefinitions(persistentEntity, persistentProperty));
        }
        return indices;
    }

    @Nullable
    protected IndexDefinitionHolder createFieldQueryIndexDefinition(CouchbasePersistentEntity<?> entity, CouchbasePersistentProperty property) {
        QueryIndexed index = (QueryIndexed)property.findAnnotation(QueryIndexed.class);
        if (index == null) {
            return null;
        }
        MappingCouchbaseEntityInformation entityInfo = new MappingCouchbaseEntityInformation(entity);
        ArrayList<String> fields = new ArrayList<String>();
        String fieldName = index.name().isEmpty() ? property.getFieldName() : index.name();
        fields.add(fieldName + (index.direction() == QueryIndexDirection.DESCENDING ? " DESC" : ""));
        String indexName = "idx_" + StringUtils.uncapitalize((String)entity.getType().getSimpleName()) + "_" + fieldName;
        return new IndexDefinitionHolder(fields, indexName, this.getPredicate(entityInfo));
    }

    protected List<IndexDefinitionHolder> createCompositeQueryIndexDefinitions(CouchbasePersistentEntity<?> entity, CouchbasePersistentProperty property) {
        ArrayList<Annotation> indexAnnotations = new ArrayList<Annotation>();
        if (entity.isAnnotationPresent(CompositeQueryIndex.class)) {
            indexAnnotations.add(entity.findAnnotation(CompositeQueryIndex.class));
        }
        if (entity.isAnnotationPresent(CompositeQueryIndexes.class)) {
            indexAnnotations.addAll(Arrays.asList(((CompositeQueryIndexes)entity.findAnnotation(CompositeQueryIndexes.class)).value()));
        }
        MappingCouchbaseEntityInformation entityInfo = new MappingCouchbaseEntityInformation(entity);
        String predicate = this.getPredicate(entityInfo);
        return indexAnnotations.stream().map(ann -> {
            List<String> fields = Arrays.asList(ann.fields());
            String fieldsIndexName = String.join((CharSequence)"_", fields).toLowerCase().replace(" ", "").replace("asc", "").replace("desc", "");
            String indexName = "idx_" + StringUtils.uncapitalize((String)entity.getType().getSimpleName()) + "_" + fieldsIndexName;
            return new IndexDefinitionHolder(fields, indexName, predicate);
        }).collect(Collectors.toList());
    }

    private String getPredicate(MappingCouchbaseEntityInformation<?, Object> entityInfo) {
        String typeKey = this.operations.getConverter().getTypeKey();
        String typeValue = entityInfo.getJavaType().getName();
        return "`" + typeKey + "` = \"" + typeValue + "\"";
    }

    public static class IndexDefinitionHolder
    implements IndexDefinition {
        private final List<String> fields;
        private final String indexName;
        private final String indexPredicate;

        public IndexDefinitionHolder(List<String> fields, String indexName, String indexPredicate) {
            this.fields = fields;
            this.indexName = indexName;
            this.indexPredicate = indexPredicate;
        }

        @Override
        public List<String> getIndexFields() {
            return this.fields;
        }

        @Override
        public String getIndexName() {
            return this.indexName;
        }

        @Override
        public String getIndexPredicate() {
            return this.indexPredicate;
        }
    }
}

