/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping.event;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.event.AbstractCouchbaseEventListener;
import org.springframework.util.Assert;

public class ValidatingCouchbaseEventListener
extends AbstractCouchbaseEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingCouchbaseEventListener.class);
    private final Validator validator;

    public ValidatingCouchbaseEventListener(Validator validator) {
        Assert.notNull((Object)validator, (String)"Validator must not be null!");
        this.validator = validator;
    }

    @Override
    public void onBeforeSave(Object source, CouchbaseDocument dbo) {
        Set violations;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating object: {}", source);
        }
        if (!(violations = this.validator.validate(source, new Class[0])).isEmpty()) {
            LOG.info("During object: {} validation violations found: {}", source, (Object)violations);
            throw new ConstraintViolationException(violations);
        }
    }
}

