/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonValue;
import com.couchbase.client.java.query.QueryScanConsistency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.N1QLQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseParameterAccessor;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import reactor.core.publisher.Flux;

public abstract class ReactiveAbstractN1qlBasedQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveAbstractN1qlBasedQuery.class);
    protected final CouchbaseQueryMethod queryMethod;
    private final ReactiveCouchbaseOperations couchbaseOperations;

    protected ReactiveAbstractN1qlBasedQuery(CouchbaseQueryMethod method, ReactiveCouchbaseOperations operations) {
        this.queryMethod = method;
        this.couchbaseOperations = operations;
    }

    protected abstract N1QLExpression getExpression(ParameterAccessor var1, Object[] var2, ReturnedType var3);

    protected abstract JsonValue getPlaceholderValues(ParameterAccessor var1);

    public Object execute(Object[] parameters) {
        ReactiveCouchbaseParameterAccessor accessor = new ReactiveCouchbaseParameterAccessor(this.queryMethod, parameters);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ReturnedType returnedType = processor.getReturnedType();
        Class typeToRead = returnedType.getTypeToRead();
        typeToRead = typeToRead == null ? returnedType.getDomainType() : typeToRead;
        N1QLExpression expression = this.getExpression((ParameterAccessor)accessor, parameters, returnedType);
        JsonValue queryPlaceholderValues = this.getPlaceholderValues((ParameterAccessor)accessor);
        N1QLQuery query = N1qlUtils.buildQuery(expression, queryPlaceholderValues, this.getScanConsistency());
        return ReactiveWrapperConverters.toWrapper((Object)processor.processResult(this.executeDependingOnType(query, this.queryMethod, typeToRead)), Flux.class);
    }

    protected Object executeDependingOnType(N1QLQuery query, QueryMethod queryMethod, Class<?> typeToRead) {
        if (queryMethod.isModifyingQuery()) {
            throw new UnsupportedOperationException("Modifying queries not yet supported");
        }
        if (queryMethod.isQueryForEntity()) {
            return this.execute(query, typeToRead);
        }
        return this.executeSingleProjection(query, typeToRead);
    }

    private void logIfNecessary(N1QLQuery query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing N1QL query: " + query.n1ql());
        }
    }

    protected Object execute(N1QLQuery query, Class<?> typeToRead) {
        throw new UnsupportedOperationException();
    }

    protected Object executeSingleProjection(N1QLQuery query, Class<?> typeToRead) {
        throw new UnsupportedOperationException();
    }

    public CouchbaseQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected ReactiveCouchbaseOperations getCouchbaseOperations() {
        return this.couchbaseOperations;
    }

    protected QueryScanConsistency getScanConsistency() {
        throw new UnsupportedOperationException();
    }
}

