/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.util.Iterator;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.couchbase.core.query.StringQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class StringN1qlQueryCreator
extends AbstractQueryCreator<Query, QueryCriteria> {
    private final ParameterAccessor accessor;
    private final MappingContext<?, CouchbasePersistentProperty> context;
    private final SpelExpressionParser parser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final StringBasedN1qlQueryParser queryParser;
    private final QueryMethod queryMethod;
    private final CouchbaseConverter couchbaseConverter;
    private final N1QLExpression parsedExpression;

    public StringN1qlQueryCreator(ParameterAccessor accessor, CouchbaseQueryMethod queryMethod, CouchbaseConverter couchbaseConverter, String bucketName, SpelExpressionParser spelExpressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider, NamedQueries namedQueries) {
        super(new PartTree("dummy", new Object(){
            String dummy;
        }.getClass()), accessor);
        String queryString;
        this.accessor = accessor;
        this.context = couchbaseConverter.getMappingContext();
        this.queryMethod = queryMethod;
        this.couchbaseConverter = couchbaseConverter;
        this.evaluationContextProvider = evaluationContextProvider;
        String namedQueryName = queryMethod.getNamedQueryName();
        if (queryMethod.hasInlineN1qlQuery()) {
            queryString = queryMethod.getInlineN1qlQuery();
        } else if (namedQueries.hasQuery(namedQueryName)) {
            queryString = namedQueries.getQuery(namedQueryName);
        } else {
            throw new IllegalArgumentException("query has no inline Query or named Query not found");
        }
        this.queryParser = new StringBasedN1qlQueryParser(queryString, queryMethod, bucketName, couchbaseConverter, this.getTypeField(), this.getTypeValue(), accessor, spelExpressionParser, evaluationContextProvider);
        this.parser = spelExpressionParser;
        this.parsedExpression = this.queryParser.parsedExpression;
    }

    protected QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected String getTypeField() {
        return this.couchbaseConverter.getTypeKey();
    }

    protected String getTypeValue() {
        return this.getQueryMethod().getEntityInformation().getJavaType().getName();
    }

    protected QueryCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, QueryCriteria.where(N1QLExpression.x(path.toDotPath())), iterator);
    }

    protected QueryCriteria and(Part part, QueryCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(N1QLExpression.x(path.toDotPath())), iterator);
    }

    protected QueryCriteria or(QueryCriteria base, QueryCriteria criteria) {
        return base.or(criteria);
    }

    protected Query complete(QueryCriteria criteria, Sort sort) {
        Query q = new StringQuery(this.parsedExpression.toString()).with(sort);
        JsonValue params = this.queryParser.getPlaceholderValues(this.accessor);
        if (params instanceof JsonArray) {
            q.setPositionalParameters((JsonArray)params);
        } else {
            q.setNamedParameters((JsonObject)params);
        }
        return q;
    }

    private QueryCriteria from(Part part, CouchbasePersistentProperty property, QueryCriteria criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case SIMPLE_PROPERTY: {
                return criteria;
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }
}

