/*
 * Copyright 2012-2020 the original author or authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.couchbase.core;

import java.util.Collection;
import java.util.List;

import org.springframework.data.couchbase.core.support.OneAndAllId;
import org.springframework.data.couchbase.core.support.WithCollection;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;

public interface ExecutableRemoveByIdOperation {

	ExecutableRemoveById removeById();

	interface TerminatingRemoveById extends OneAndAllId<RemoveResult> {

		RemoveResult one(String id);

		List<RemoveResult> all(Collection<String> ids);

	}

	interface RemoveByIdWithCollection extends TerminatingRemoveById, WithCollection<RemoveResult> {

		TerminatingRemoveById inCollection(String collection);
	}

	interface RemoveByIdWithDurability extends RemoveByIdWithCollection, WithDurability<RemoveResult> {

		RemoveByIdWithCollection withDurability(DurabilityLevel durabilityLevel);

		RemoveByIdWithCollection withDurability(PersistTo persistTo, ReplicateTo replicateTo);

	}

	interface RemoveByIdWithCas extends RemoveByIdWithDurability {

		RemoveByIdWithDurability withCas(Long cas);
	}

	interface ExecutableRemoveById extends RemoveByIdWithCas {}

}
